/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac;

import cl.uoh.abaumgart.eqnauac.algo.AntiUnif;
import cl.uoh.abaumgart.eqnauac.algo.AntiUnifAlgorithm;
import cl.uoh.abaumgart.eqnauac.algo.AntiUnifyProblem;
import cl.uoh.abaumgart.eqnauac.algo.AntiUnifyProblemSequence;
import cl.uoh.abaumgart.eqnauac.algo.AntiUnifySystem;
import cl.uoh.abaumgart.eqnauac.data.FreshnessCtx;
import cl.uoh.abaumgart.eqnauac.data.InputParser;
import cl.uoh.abaumgart.eqnauac.data.NominalPair;
import cl.uoh.abaumgart.eqnauac.data.term.FunctionApplication;
import cl.uoh.abaumgart.eqnauac.data.term.TermSymbols;
import cl.uoh.abaumgart.eqnauac.data.term.Variable;
import cl.uoh.abaumgart.eqnauac.util.VirtualLogging;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;

public class AntiUnifyMain
implements VirtualLogging {
    public static void main(String[] args) {
        System.out.println("TEST RUN. Use Client to solve your own problem!\n");
        try {
            new AntiUnifyMain().test1();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("TEST RUN. Use Client to solve your own problem!\n");
    }

    public void test1() throws IOException {
        AntiUnifyMain.LOGGING_CONFIG.logLevel = LVL_SIMPLE_AU;
        this.doAntiUnify("f(b, a, c, a, b.b, g(a)) =^= f(c, d, b, a, b, c, a.a, g(c))", "", "f", "f", "", true, false, 1);
        AntiUnifyMain.LOGGING_CONFIG.logLevel = LVL_SIMPLE_AU;
        this.doAntiUnify("f(f(a,b),c) =^= f(b,f(c,a))", "", "", "f", "", true, false, 2);
        this.doAntiUnify("f(a,b,a) =^= f(Y, a, (a b)Y)", "b#Y", "f", "", "");
        this.doAntiUnify("f(a,b) =^= f(a,b)", "", "", "", "");
        this.doAntiUnify("f(a,b,c) =^= f(b,c,a)", "", "f", "f", "");
        this.doAntiUnify("f(a,a) =^= f(b,b)", "", "", "", "");
        this.doAntiUnify("f(a,a) =^= f(b,c)", "", "", "", "");
        this.doAntiUnify("f(a,b) =^= f(b,c)", "", "", "", "");
        this.doAntiUnify("a.a =^= b.c", "", "", "", "");
        this.doAntiUnify("a.b =^= b.a", "", "", "", "");
        this.doAntiUnify("a.b =^= b.a", "", "", "", "c");
        this.doAntiUnify("f(a,b) =^= f(Y,(a b)Y)", "b#Y", "", "", "");
        this.doAntiUnify("f(b,a) =^= f(Y,(a b)Y)", "b#Y", "", "", "");
        this.doAntiUnify("h(a.a, b.b)> =^= h(c.Y, c.Y)>", "a#Y", "", "", "");
        this.doAntiUnify("h(a.a, b.b)> =^= h(c.Y, c.Y)>", "", "", "", "");
        this.doAntiUnify("h(f(X1), c.f(X1)) =^= h(g(X2), c.g(X2))", "c#X1, c#X2", "", "", "");
        this.doAntiUnify("h(f(X1), a.f((a c)X1)) =^= h(g(X2), b.g((b c)X2))", "a#X1,b#X1,c#X1,a#X2,b#X2,c#X2", "", "", "");
        this.doAntiUnify("h(f(X1), a.f((a c)X1)) =^= h(g(X2), b.g((b c)X2))", "a#X1,b#X1,c#X1,a#X2,b#X2,c#X2", "f,g,h", "f,g,h", "");
        this.doAntiUnify("h(f(X1), a.f(X2)) =^= h(g(X1), a.g(X2))", "a#X1", "", "", "");
        this.doAntiUnify("a.f(a,b) =^= b.f(b,a)", "", "", "", "");
        this.doAntiUnify("a.f(a,b) =^= b.f(b,a)", "", "", "", "c");
        this.doAntiUnify("a.b.c =^= c.a.b", "", "", "", "");
        this.doAntiUnify("a.b.b =^= b.b.a", "", "", "", "");
        this.doAntiUnify("f(a.b, X) =^= f(b.a, Y)", "c#X", "", "", "");
        this.doAntiUnify("h(f(X1), a.a.f((a c)X1)) =^= h(g(X2), c.b.g((b c)X2))", "{a#X1,b#X1,c#X1}", "", "", "");
        this.doAntiUnify("f(X,X,Y,Y) =^= f(Z,Z,Z,V)", "", "", "", "");
        this.doAntiUnify("f(X,X,Y,Y) =^= f(X,X,X,Z)", "", "", "", "");
        this.doAntiUnify("a =^= b", "", "", "", "");
        this.doAntiUnify("X =^= (a b)X", "", "", "", "");
    }

    public void doAntiUnify(String problemSetIn, String inNabla, String associative, String commutative, String extra) throws IOException {
        this.doAntiUnify(problemSetIn, inNabla, associative, commutative, extra, true, false);
    }

    public void doAntiUnify(String problemSetIn, String inNabla, String associative, String commutative, String extra, boolean rearrange, boolean linear) throws IOException {
        this.doAntiUnify(problemSetIn, inNabla, associative, commutative, extra, rearrange, linear, -1);
    }

    public void doAntiUnify(String problemSetIn, String inNabla, String associative, String commutative, String extra, boolean rearrange, boolean linear, int branchLimit) throws IOException {
        FunctionApplication.REARRANGE_COMMUTATIVE = rearrange;
        TermSymbols.resetAll();
        TermSymbols.addFncSymbsC(commutative);
        TermSymbols.addFncSymbsA(associative);
        TermSymbols.parseAtoms(extra);
        FreshnessCtx nabla = this.parseNabla(inNabla);
        AntiUnifyProblemSequence problemSet = this.parseEquationSystem(problemSetIn);
        List<Variable> genVars = problemSet.stream().map(AntiUnifyProblem::getGeneralizationVar).toList();
        AntiUnifySystem auSys = new AntiUnifySystem(problemSet, nabla);
        this.logInfo(LVL_SIMPLE_AU, "Input problem set: ", problemSet);
        this.logInfo(LVL_SIMPLE_AU, "Input freshness context: ", nabla);
        this.logInfo(LVL_SIMPLE_AU, "Input associative symbols: ", TermSymbols.toSet(TermSymbols.fncSymbA), ", commutative symbols: ", TermSymbols.toSet(TermSymbols.fncSymbC));
        this.logInfo(LVL_SIMPLE_AU, "Use branching heuristics: ", rearrange);
        AntiUnif au = new AntiUnif(auSys, new AntiUnifAlgorithm(linear), branchLimit);
        long cnt = 1L;
        for (AntiUnifySystem sys : au) {
            for (Variable genVar : genVars) {
                this.logMsg(LVL_OFF, "\nResult branch ", cnt, ": ", new NominalPair(sys.nablaOut, sys.sigma.get(genVar)));
            }
            this.logMsg(LVL_VERBOSE_AU, sys);
            ++cnt;
        }
        if (au.lastIteratorLimitExceeded()) {
            this.logWarn("\nLimit of " + branchLimit + " branches has been exceeded!");
        }
    }

    private AntiUnifyProblemSequence parseEquationSystem(String in) throws IOException {
        AntiUnifyProblemSequence eqSys = new AntiUnifyProblemSequence();
        new InputParser().parseEquationSystem(new StringReader(in), eqSys);
        return eqSys;
    }

    private FreshnessCtx parseNabla(String in) throws IOException {
        return new InputParser().parseNabla(new StringReader(in));
    }
}

