/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac;

import cl.uoh.abaumgart.eqnauac.AntiUnifyMain;
import cl.uoh.abaumgart.eqnauac.EquivarianceMain;
import cl.uoh.abaumgart.eqnauac.util.VirtualLogging;
import java.util.logging.Level;

public class Client
implements VirtualLogging {
    public Client(String[] args) {
        try {
            if (args.length < 3 || this.isHelpRequest(args[0])) {
                this.printHelp();
                return;
            }
            Client.LOGGING_CONFIG.logLevel = this.parseLogLevel(args[0], args[1]);
            String fresh = "";
            String assoc = "";
            String commu = "";
            String extra = "";
            boolean rearrange = true;
            boolean linear = false;
            int branchLimit = -1;
            if (args.length >= 4) {
                fresh = args[3];
            }
            if (args.length >= 6) {
                assoc = args[4];
                commu = args[5];
                if (args.length > 6) {
                    extra = args[6];
                }
                if (args.length > 7) {
                    rearrange = this.booleanArg(args[7]);
                }
                if (args.length > 8) {
                    linear = this.booleanArg(args[8]);
                }
                if (args.length > 9) {
                    branchLimit = Integer.parseInt(args[9]);
                }
            } else if (args.length == 5) {
                extra = args[4];
            }
            switch (args[0]) {
                case "AU": {
                    new AntiUnifyMain().doAntiUnify(args[2], fresh, assoc, commu, extra, rearrange, linear, branchLimit);
                    break;
                }
                case "EQ": {
                    new EquivarianceMain().doEquivariance(args[2], fresh, assoc, commu, extra, rearrange);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("First argument is invalid. \"AU\" or \"EQ\" expected.");
                }
            }
        }
        catch (Exception ex) {
            try {
                this.logErr(ex);
            }
            catch (Exception logEx) {
                ex.printStackTrace();
                logEx.printStackTrace();
                this.logErr(logEx);
            }
        }
    }

    private boolean booleanArg(String arg) {
        char firstC = Character.toLowerCase(arg.charAt(0));
        return firstC == 't' || firstC == 'y';
    }

    private boolean isHelpRequest(String msg) {
        String msgLC = msg == null ? "?" : msg.toLowerCase().replace("-", "");
        return "?".equals(msgLC) || "h".equals(msgLC) || "help".equals(msgLC);
    }

    private Level parseLogLevel(String fnc, String level) {
        return switch (level) {
            case "SILENT" -> LVL_OFF;
            case "SIMPLE" -> {
                if ("AU".equals(fnc)) {
                    yield LVL_SIMPLE_AU;
                }
                yield LVL_SIMPLE_EQ;
            }
            case "VERBOSE" -> {
                if ("AU".equals(fnc)) {
                    yield LVL_VERBOSE_AU;
                }
                yield LVL_VERBOSE_EQ;
            }
            case "PROGRESS" -> {
                if ("AU".equals(fnc)) {
                    yield LVL_PROGRESS_AU;
                }
                yield LVL_PROGRESS_EQ;
            }
            case "ALL" -> LVL_ALL;
            default -> throw new IllegalArgumentException("Invalid argument " + level + ". Log-Level expected.");
        };
    }

    private void printHelp() {
        this.logInfo("");
        this.logInfo("USAGE: java -jar eqnauac-lib.jar arg_1 ... arg_n");
        this.logInfo("");
        this.logInfo(" arg_1 : specifies the algorithm. There are 3 algorithms available:");
        this.logInfo("         AU = anti-unification solver");
        this.logInfo("         EQ = equivariance solver");
        this.logInfo(" arg_2 : specifies the log-level. There are 5 levels available:");
        this.logInfo("         SIMPLE   = the results are displayed");
        this.logInfo("         VERBOSE  = some additional informations are displayed");
        this.logInfo("         PROGRESS = rule applications are displayed");
        this.logInfo("         ALL      = all debug informations are displayed");
        this.logInfo("         SILENT   = no output in the case of success. Errors are displayed.");
        this.logInfo("                    Useful to embed the library instead of executing the jar file");
        this.logInfo(" arg_3 : the problem set");
        this.logInfo("[arg_4]: the freshness context");
        this.logInfo("[arg_5]: associative function symbols");
        this.logInfo("[arg_6]: commutative function symbols");
        this.logInfo("[arg_7]: extra atoms (arg_5 if associative AND commutative symbols are missing)");
        this.logInfo("[arg_8]: align commutative arguments (default=true)");
        this.logInfo("[arg_9]: compute linear generalizations (default=false)");
        this.logInfo("[arg_10]: branch limit (default=-1)");
        this.logInfo("");
        this.logInfo("Some examples:");
        this.logInfo("java -jar eqnauac-lib.jar AU SIMPLE \"f(a,b,a) =^= f(Y, a, (a b)Y)\" \"b#Y\"");
        this.logInfo("java -jar eqnauac-lib.jar AU SIMPLE \"f(f(a,b),a) =^= f(b,f(b,a))\" \"\" \"f\" \"f\"");
        this.logInfo("java -jar eqnauac-lib.jar AU VERBOSE \"f(a,b,a) =^= f(Y, a, (a b)Y)\" \"b#Y\" \"\" \"f\"");
        this.logInfo("java -jar eqnauac-lib.jar AU PROGRESS \"a.b =^= b.a\" \"\" \"c,d\"");
        this.logInfo("java -jar eqnauac-lib.jar AU PROGRESS \"f(a.b, c) =^= f(c, b.a)\" \"\" \"f\" \"f\" \"d,e\"");
        this.logInfo("java -jar eqnauac-lib.jar EQ PROGRESS \"f(a,b) =< f(b,a)\"");
        this.logInfo("java -jar eqnauac-lib.jar EQ SIMPLE \"f(X,f(b,c)) =< f((a,b)X,f(a,d))\" \"c#X, d#X\"");
        this.logInfo("");
        this.logInfo("arg_5 and arg_6 may be omitted TOGETHER. It's not allowed to only omit one of them.");
        this.logInfo("");
    }

    public static void main(String[] args) {
        new Client(args);
    }
}

