/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac;

import cl.uoh.abaumgart.eqnauac.algo.Equivariance;
import cl.uoh.abaumgart.eqnauac.algo.EquivarianceAlgorithm;
import cl.uoh.abaumgart.eqnauac.algo.EquivarianceProblemSequence;
import cl.uoh.abaumgart.eqnauac.algo.EquivarianceSystem;
import cl.uoh.abaumgart.eqnauac.data.FreshnessCtx;
import cl.uoh.abaumgart.eqnauac.data.InputParser;
import cl.uoh.abaumgart.eqnauac.data.term.FunctionApplication;
import cl.uoh.abaumgart.eqnauac.data.term.Permutation;
import cl.uoh.abaumgart.eqnauac.data.term.TermSymbols;
import cl.uoh.abaumgart.eqnauac.util.VirtualLogging;
import java.io.IOException;
import java.io.StringReader;

public class EquivarianceMain
implements VirtualLogging {
    public static void main(String[] args) {
        System.out.println("TEST RUN. Use Client to solve your own problem!\n");
        try {
            new EquivarianceMain().test1();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("TEST RUN. Use Client to solve your own problem!\n");
    }

    private void test1() throws IOException {
        EquivarianceMain.LOGGING_CONFIG.logLevel = LVL_SIMPLE_EQ;
        this.doEquivariance("f(a,b) = f(a,b)", "", "", "", "");
        this.doEquivariance("f(a.a,b) = f(a.a,a)", "", "", "", "");
        this.doEquivariance("f(a.a,b) = f(a,a.a)", "", "f", "f", "");
        this.doEquivariance("f(a,b) = f(b,a)", "", "", "", "");
        this.doEquivariance("f(a,a) = f(b,b)", "", "", "", "");
        this.doEquivariance("f(a,a) = f(b,c)", "", "", "", "");
        this.doEquivariance("f(a,b) = f(b,c)", "", "", "", "");
        this.doEquivariance("f(a,b,a.X) =^= f(b,c,c.X)", "a#X, b#X, c#X", "", "", "a, b, c, d");
        this.doEquivariance("a.a = b.c", "", "", "", "");
        this.doEquivariance("a.b = b.a", "", "", "", "");
        this.doEquivariance("a.b = b.a", "", "", "", "a,b,c");
        this.doEquivariance("h(X1, c.X1) =^= h(X1, c.X1)", "", "", "", "");
        this.doEquivariance("h(X1, a.(a c)X1) =^= h(X1, b.(b c)X1)", "a#X1,b#X1,c#X1", "", "", "");
        this.doEquivariance("h(X1, a.X2) =^= h(X1, a.X2)", "a#X1", "", "", "");
        this.doEquivariance("a.f(a,b) =^= b.f(b,a)", "", "", "", "");
        this.doEquivariance("a.f(a,b) =^= b.f(b,a)", "", "", "", "a,b,c");
        this.doEquivariance("a.b.c =^= c.a.b", "", "", "", "");
        this.doEquivariance("a.b.b =^= b.b.a", "", "", "", "");
        this.doEquivariance("f(a.b, X) =^= f(b.a, X)", "c#X", "", "", "");
        this.doEquivariance("h(X1, a.a.(a c)X1) =^= h(X1, c.b.(b c)X1)", "{a#X1,b#X1,c#X1}", "", "", "");
    }

    public void doEquivariance(String problemSetIn, String inNabla, String associative, String commutative, String extra) throws IOException {
        this.doEquivariance(problemSetIn, inNabla, associative, commutative, extra, false);
    }

    public void doEquivariance(String problemSetIn, String inNabla, String associative, String commutative, String extra, boolean rearrange) throws IOException {
        FunctionApplication.REARRANGE_COMMUTATIVE = rearrange;
        TermSymbols.resetAll();
        TermSymbols.addFncSymbsC(commutative);
        TermSymbols.addFncSymbsA(associative);
        TermSymbols.parseAtoms(extra);
        FreshnessCtx nabla = this.parseNabla(inNabla);
        EquivarianceProblemSequence problemSet = this.parseEquationSystem(problemSetIn);
        EquivarianceSystem eqSys = new EquivarianceSystem(problemSet, nabla);
        this.logInfo(LVL_SIMPLE_EQ, "Input problem set: ", problemSet);
        this.logInfo(LVL_SIMPLE_EQ, "Input freshness context: ", nabla);
        this.logInfo(LVL_SIMPLE_EQ, "Input associative symbols: ", TermSymbols.toSet(TermSymbols.fncSymbA), ", commutative symbols: ", TermSymbols.toSet(TermSymbols.fncSymbC));
        Equivariance eq = new Equivariance(eqSys, new EquivarianceAlgorithm());
        long cnt = 1L;
        for (Permutation perm : eq) {
            this.logMsg(LVL_OFF, "\nEquivariant. Permutation ", cnt, ": ", perm.toString(true));
            ++cnt;
        }
        if (cnt == 1L) {
            this.logMsg(LVL_OFF, "\nNot equivariant.");
        }
    }

    private EquivarianceProblemSequence parseEquationSystem(String in) throws IOException {
        EquivarianceProblemSequence eqSys = new EquivarianceProblemSequence();
        new InputParser().parseEquationSystem(new StringReader(in), eqSys);
        return eqSys;
    }

    private FreshnessCtx parseNabla(String in) throws IOException {
        return new InputParser().parseNabla(new StringReader(in));
    }
}

