/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac;

import java.util.Objects;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.xml.Node;

public class HtmlWriter
extends Thread {
    private boolean error;
    private boolean compact;
    private boolean running = true;
    private HTMLDocument document;
    private HTMLElement outputRoot;
    private HTMLElement outElem;
    private String out;
    private String outStyle;
    private String oldStyle = "INIT";
    private long lineNr;
    private long maxLines;
    private RuntimeException processingException;

    public HtmlWriter(long maxLines, boolean compact) {
        this.maxLines = maxLines;
        this.compact = compact;
        this.document = HTMLDocument.current();
        this.outputRoot = this.document.createElement("div");
        this.document.getElementById("teavm-out").replaceChild((Node)this.outputRoot, this.document.getElementById("teavm-out").getFirstChild());
    }

    @Override
    public void run() {
        while (this.running) {
            if (this.out != null) {
                try {
                    this.write(this.out, this.outStyle);
                }
                catch (RuntimeException ex) {
                    this.processingException = ex;
                }
                this.out = null;
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String lines, String style) {
        if (!Objects.equals(this.oldStyle, style)) {
            this.outElem = this.document.createElement("pre");
            if (style != null) {
                this.outElem.setAttribute("style", style);
            }
            this.outputRoot.appendChild((Node)this.outElem);
            this.oldStyle = style;
        }
        String[] lArr = lines.split("\\r?\\n");
        StringBuilder lOut = new StringBuilder(lines.length() + lArr.length * 8);
        try {
            for (String l : lArr) {
                if (this.compact && l.isBlank()) continue;
                lOut.append(this.prepareLine(l));
            }
        }
        finally {
            this.outElem.appendChild((Node)this.document.createTextNode(lOut.toString()));
        }
    }

    private String prepareLine(String line) {
        if (this.lineNr == this.maxLines) {
            this.maxLines = -1L;
            throw new IndexOutOfBoundsException("Maximum number of output lines reached. (You can change this limit in the input area above.)");
        }
        ++this.lineNr;
        String lineStr = this.lineNr > 999999L ? String.valueOf(this.lineNr) : String.valueOf(this.lineNr + 1000000L).substring(1);
        return lineStr + " " + line + "\n";
    }

    public void out(String msg) {
        this.out(msg, null);
    }

    public void outGray(String msg) {
        this.out(msg, "color:gray");
    }

    public void outRed(String msg) {
        this.out(msg, "color:red");
    }

    public void outYellow(String msg) {
        this.out(msg, "color:orange");
    }

    public void err(Throwable ex) {
        String msg = ex.getMessage();
        if (msg == null || msg.trim().isEmpty()) {
            msg = ex.getClass().getSimpleName();
        }
        this.error = true;
        this.outRed(msg);
    }

    public void out(String msg, String style) {
        this.out = msg;
        this.outStyle = style;
        this.waitProc();
    }

    private void waitProc() {
        boolean needWait;
        do {
            needWait = this.out != null;
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (needWait);
        RuntimeException exOccured = this.processingException;
        if (exOccured != null) {
            this.processingException = null;
            throw exOccured;
        }
    }

    public void shutdown() {
        try {
            this.writeFinished();
        }
        catch (Exception ignore) {
            this.writeFinished();
        }
        finally {
            this.running = false;
        }
    }

    private void writeFinished() {
        if (this.error) {
            this.outRed("\nERROR.");
        } else {
            this.outGray("\nDone.");
        }
    }
}

