/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac;

import cl.uoh.abaumgart.eqnauac.algo.AntiUnifyProblemSequence;
import cl.uoh.abaumgart.eqnauac.data.FreshnessCtx;
import cl.uoh.abaumgart.eqnauac.data.InputParser;
import cl.uoh.abaumgart.eqnauac.data.term.Atom;
import cl.uoh.abaumgart.eqnauac.data.term.NominalTerm;
import cl.uoh.abaumgart.eqnauac.data.term.TermSymbols;
import cl.uoh.abaumgart.eqnauac.util.ControlledException;
import java.io.IOException;
import java.io.StringReader;

public class TestParser
implements TermSymbols {
    public static void main(String[] args) {
        try {
            TestParser.test();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void test() throws Exception {
        TestParser.parseNabla("");
        TestParser.parseNabla("a#Xalhg");
        TestParser.parseNabla("a#X,b#Y");
        TestParser.parseNabla(" \n\t   a#\nX, b# Y ");
        TestParser.parseNabla("{c#X,b#Y}");
        TestParser.parseTerm("a.f(a,b,(a b)X)");
        TestParser.parseTerm("  (a b)(c d)(a d)(af e)Y");
        TestParser.parseTerm(" (a b)(c d)(a d)(af e)Y  ");
        TestParser.parseTerm("(a b)(c d)(a d)(af e)Y");
        TestParser.parseEquationSystem("a=b");
        TestParser.parseEquationSystem("a=^=b");
        TestParser.parseEquationSystem("a =^= \n b");
        TestParser.parseEquationSystem("a=b;c =^= \n b");
        TestParser.parseEquationSystem("a.f(a,b,(a b)X)=^= a.f[a,b,(a b)X], a.f(a,b,(a b)X)=a.f(a,b,(a b)X),  a.f(a,b,(a b)X)=a.f(a,b,(a b)X),  (a b)(c d)(a d)(af e)Y=(a b)(c d)(a d)(af e)Y, (a b)(c d)(a d)(af e)Y= (a b)(c d)(a d)(af e)Y");
    }

    private static void parseTerm(String nomTerm) throws Exception {
        InputParser nParse = new InputParser();
        NominalTerm np = nParse.parseTerm(new StringReader(nomTerm), true);
        np.printString(System.out);
        System.out.print(" ==> SWAP (a c) ==> ");
        Atom a1 = (Atom)atomSymb.parseSymbol("a");
        Atom a2 = (Atom)atomSymb.parseSymbol("c");
        np.swap(a1, a2);
        np.printString(System.out);
        System.out.println();
    }

    private static void parseNabla(String input) throws Exception {
        InputParser nParse = new InputParser();
        FreshnessCtx nabla = nParse.parseNabla(new StringReader(input));
        nabla.printString(System.out);
        System.out.print(" ==> SWAP (a c) ==> ");
        Atom a1 = (Atom)atomSymb.parseSymbol("a");
        Atom a2 = (Atom)atomSymb.parseSymbol("c");
        nabla.swap(a1, a2).printString(System.out);
        System.out.println();
    }

    private static void parseEquationSystem(String nomEqSysIn) throws IOException, ControlledException {
        InputParser nParse = new InputParser();
        AntiUnifyProblemSequence nomEqSysOut = new AntiUnifyProblemSequence();
        nParse.parseEquationSystem(new StringReader(nomEqSysIn), nomEqSysOut);
        nomEqSysOut.printString(System.out);
        System.out.println();
    }
}

