/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.algo;

import cl.uoh.abaumgart.eqnauac.data.term.NominalTerm;
import cl.uoh.abaumgart.eqnauac.data.term.TermSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ACDecomposer
implements Iterable<ACDecomposition>,
Iterator<ACDecomposition>,
TermSymbols {
    private final NominalTerm[] args;
    int numBuckets = 2;
    private int[] idx;
    private int[] aux;

    public ACDecomposer(NominalTerm[] args) {
        this.args = args;
        this.initBuckets();
    }

    @Override
    public Iterator<ACDecomposition> iterator() {
        if (this.numBuckets != 2) {
            this.numBuckets = 2;
            this.initBuckets();
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.numBuckets == 2;
    }

    @Override
    public ACDecomposition next() {
        ACDecomposition decomposition = new ACDecomposition();
        for (int i = 0; i < this.args.length; ++i) {
            decomposition.add(this.args[i], this.idx[i]);
        }
        this.nextPartition();
        return decomposition;
    }

    private void initBuckets() {
        this.idx = new int[this.args.length];
        this.aux = new int[this.args.length];
        for (int i = this.args.length - this.numBuckets + 1; i < this.args.length; ++i) {
            this.idx[i] = this.aux[i] = i - this.args.length + this.numBuckets;
        }
    }

    private void nextPartition() {
        for (int i = this.args.length - 1; i > 0; --i) {
            if (this.idx[i] >= this.numBuckets - 1 || this.idx[i] > this.aux[i - 1]) continue;
            int n = i;
            this.idx[n] = this.idx[n] + 1;
            this.aux[i] = Math.max(this.aux[i], this.idx[i]);
            int n2 = this.args.length - this.numBuckets + this.aux[i];
            for (int j = i + 1; j < this.args.length; ++j) {
                if (j > n2) {
                    this.idx[j] = this.aux[j] = this.numBuckets - this.args.length + j;
                    continue;
                }
                this.idx[j] = 0;
                this.aux[j] = this.aux[i];
            }
            return;
        }
        --this.numBuckets;
    }

    public static class ACDecomposition {
        public final List<NominalTerm> bucket0 = new ArrayList<NominalTerm>();
        public final List<NominalTerm> bucket1 = new ArrayList<NominalTerm>();

        public void add(NominalTerm term, int i) {
            if (i == 0) {
                this.bucket0.add(term);
            } else {
                this.bucket1.add(term);
            }
        }

        public String toString() {
            return String.valueOf(this.bucket0) + " / " + String.valueOf(this.bucket1);
        }
    }
}

