/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.algo;

import cl.uoh.abaumgart.eqnauac.algo.AntiUnifApplicable;
import cl.uoh.abaumgart.eqnauac.algo.AntiUnifySystem;
import cl.uoh.abaumgart.eqnauac.algo.AntiUnifySystemStack;
import cl.uoh.abaumgart.eqnauac.util.VirtualLogging;
import java.util.Iterator;

public class AntiUnif
implements Iterable<AntiUnifySystem>,
VirtualLogging {
    private final AntiUnifySystem originalAup;
    private final AntiUnifApplicable algorithm;
    private final int branchLimit;
    private AntiUnifSystemIter lastIterator;

    public AntiUnif(AntiUnifySystem originalAup, AntiUnifApplicable algorithm, int branchLimit) {
        this.originalAup = originalAup;
        this.algorithm = algorithm;
        this.branchLimit = branchLimit;
    }

    public boolean lastIteratorLimitExceeded() {
        return this.lastIterator.aupSystems.isLimitExceeded();
    }

    @Override
    public Iterator<AntiUnifySystem> iterator() {
        this.lastIterator = new AntiUnifSystemIter(this.originalAup.deepCopy());
        return this.lastIterator;
    }

    public class AntiUnifSystemIter
    implements Iterator<AntiUnifySystem> {
        private final AntiUnifySystemStack aupSystems;

        public AntiUnifSystemIter(AntiUnifySystem sysIn) {
            this.aupSystems = new AntiUnifySystemStack(AntiUnif.this.branchLimit);
            this.aupSystems.add(sysIn);
        }

        @Override
        public boolean hasNext() {
            return !this.aupSystems.isEmpty();
        }

        @Override
        public AntiUnifySystem next() {
            AntiUnifySystem nextSys = this.aupSystems.removeLast();
            AntiUnif.this.logMsg(VirtualLogging.LVL_PROGRESS_AU, "\nSelecting anti-unify system:\n", nextSys);
            return AntiUnif.this.algorithm.apply(nextSys, this.aupSystems);
        }
    }
}

