/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.algo;

import cl.uoh.abaumgart.eqnauac.algo.ACDecomposer;
import cl.uoh.abaumgart.eqnauac.algo.Alignment;
import cl.uoh.abaumgart.eqnauac.algo.AntiUnifApplicable;
import cl.uoh.abaumgart.eqnauac.algo.AntiUnifyProblem;
import cl.uoh.abaumgart.eqnauac.algo.AntiUnifySystem;
import cl.uoh.abaumgart.eqnauac.algo.AntiUnifySystemStack;
import cl.uoh.abaumgart.eqnauac.algo.Equivariance;
import cl.uoh.abaumgart.eqnauac.algo.EquivarianceAlgorithm;
import cl.uoh.abaumgart.eqnauac.algo.EquivarianceApplicable;
import cl.uoh.abaumgart.eqnauac.algo.EquivarianceProblemSequence;
import cl.uoh.abaumgart.eqnauac.algo.EquivarianceSystem;
import cl.uoh.abaumgart.eqnauac.algo.RigidityFnc;
import cl.uoh.abaumgart.eqnauac.algo.RigidityFncSubsequence;
import cl.uoh.abaumgart.eqnauac.data.term.Abstraction;
import cl.uoh.abaumgart.eqnauac.data.term.Atom;
import cl.uoh.abaumgart.eqnauac.data.term.FunctionApplication;
import cl.uoh.abaumgart.eqnauac.data.term.FunctionSymbol;
import cl.uoh.abaumgart.eqnauac.data.term.NominalTerm;
import cl.uoh.abaumgart.eqnauac.data.term.Permutation;
import cl.uoh.abaumgart.eqnauac.data.term.Suspension;
import cl.uoh.abaumgart.eqnauac.data.term.TermSymbols;
import cl.uoh.abaumgart.eqnauac.data.term.Variable;
import cl.uoh.abaumgart.eqnauac.util.Printable;
import cl.uoh.abaumgart.eqnauac.util.VirtualLogging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class AntiUnifAlgorithm
implements AntiUnifApplicable,
TermSymbols,
VirtualLogging {
    public RigidityFnc rFnc = new RigidityFncSubsequence();
    public EquivarianceApplicable eqvm = new EquivarianceAlgorithm();
    private Collection<Atom> atoms = TermSymbols.atomSymb.getUsedSymbols();
    boolean linear;

    public AntiUnifAlgorithm() {
        this(false);
    }

    public AntiUnifAlgorithm(boolean linear) {
        this.linear = linear;
    }

    @Override
    public AntiUnifySystem apply(AntiUnifySystem currentSystem, AntiUnifySystemStack branchStack) {
        this.solve(currentSystem, branchStack);
        if (!this.linear) {
            this.merge(currentSystem, branchStack);
        }
        return currentSystem;
    }

    private void solve(AntiUnifySystem currSys, AntiUnifySystemStack branchStack) {
        while (!currSys.problemSet.isEmpty()) {
            int idx = 0;
            if (this.tryApplyAtm(currSys, idx) || this.tryApplyDec(currSys, idx, branchStack) || this.tryApplyAbs(currSys, idx)) continue;
            this.applySol(currSys, idx);
        }
    }

    private void merge(AntiUnifySystem currSys, AntiUnifySystemStack branchStack) {
        this.logMsg(LVL_PROGRESS_AU, "\nStart merging phase");
        long merCnt = 0L;
        for (int i = currSys.store.size() - 1; i >= 1; --i) {
            AntiUnifyProblem aup1 = (AntiUnifyProblem)currSys.store.get(i);
            for (int j = i - 1; j >= 0; --j) {
                AntiUnifyProblem aup2 = (AntiUnifyProblem)currSys.store.get(j);
                EquivarianceProblemSequence problemSet = new EquivarianceProblemSequence();
                problemSet.addNewEquation((NominalTerm)aup1.left, (NominalTerm)aup2.left);
                problemSet.addNewEquation((NominalTerm)aup1.right, (NominalTerm)aup2.right);
                EquivarianceSystem eqSys = new EquivarianceSystem(problemSet, currSys.nablaIn);
                Iterator<Permutation> perms = new Equivariance(eqSys, this.eqvm).iterator();
                if (!perms.hasNext()) continue;
                Suspension susp = new Suspension(aup1.generalizationVar, perms.next());
                currSys.sigma.composeInRange(aup2.generalizationVar, susp);
                currSys.nablaOut.substitute(aup2.generalizationVar, susp);
                currSys.store.remove(j, false);
                --i;
                this.logRuleAppl("Mer", currSys);
                ++merCnt;
            }
        }
        this.logMsg(LVL_VERBOSE_AU, "\nMerge rule applied " + merCnt + " times ==>");
    }

    private boolean tryApplyAtm(AntiUnifySystem currSys, int aupIdx) {
        AntiUnifyProblem currAup = (AntiUnifyProblem)currSys.problemSet.get(aupIdx);
        if (currAup.left == currAup.right) {
            currSys.sigma.composeInRange(currAup.generalizationVar, (NominalTerm)currAup.left);
            currSys.problemSet.remove(aupIdx, true);
            this.logRuleAppl("Dec0", currSys);
            return true;
        }
        return false;
    }

    private boolean tryApplyDec(AntiUnifySystem currSys, int aupIdx, AntiUnifySystemStack branchStack) {
        AntiUnifyProblem currAup = (AntiUnifyProblem)currSys.problemSet.get(aupIdx);
        Printable printable = currAup.left;
        if (printable instanceof FunctionApplication) {
            FunctionApplication lFnc = (FunctionApplication)printable;
            printable = currAup.right;
            if (printable instanceof FunctionApplication) {
                FunctionApplication rFnc = (FunctionApplication)printable;
                if (lFnc.fncSymb == rFnc.fncSymb) {
                    FunctionSymbol fncSymb = lFnc.fncSymb;
                    NominalTerm[] lArgs = lFnc.args;
                    NominalTerm[] rArgs = rFnc.args;
                    if (fncSymbA.contains(fncSymb)) {
                        if (lArgs.length < 2 || rArgs.length < 2) {
                            throw new AntiUnifApplicable.AntiUnifException("Associative function application must be of arity 2. Symbol=" + String.valueOf(fncSymb));
                        }
                        if (fncSymbC.contains(fncSymb)) {
                            this.applyDecAC(currSys, aupIdx, fncSymb, lArgs, rArgs, branchStack);
                            this.logRuleAppl("DecAC current branch (position 1)", currSys);
                        } else {
                            this.applyDecA(currSys, aupIdx, fncSymb, lArgs, rArgs, branchStack);
                            this.logRuleAppl("DecA current branch (position 1)", currSys);
                        }
                    } else if (fncSymbC.contains(fncSymb)) {
                        if (lArgs.length != 2 || rArgs.length != 2) {
                            throw new AntiUnifApplicable.AntiUnifException("Commutative function application must be of arity 2. Symbol=" + String.valueOf(fncSymb));
                        }
                        this.applyDecC(currSys, aupIdx, fncSymb, lArgs, rArgs, branchStack);
                        this.logRuleAppl("DecC current branch (position 1)", currSys);
                    } else {
                        if (lArgs.length != rArgs.length) {
                            throw new AntiUnifApplicable.AntiUnifException("Contradicting arity of function application. Symbol=" + String.valueOf(fncSymb));
                        }
                        this.applyDec0(currSys, aupIdx, fncSymb, lArgs, rArgs);
                        this.logRuleAppl("Dec0", currSys);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private void applyDecAC(AntiUnifySystem currSys, int aupIdx, FunctionSymbol fncSymb, NominalTerm[] lArgs, NominalTerm[] rArgs, AntiUnifySystemStack branchStack) {
        AntiUnifyProblem currAup = (AntiUnifyProblem)currSys.problemSet.get(aupIdx);
        AntiUnifyProblem newAup = this.prepareDecBranch(currSys, aupIdx, currAup, fncSymb, lArgs, rArgs, FunctionApplication.REARRANGE_COMMUTATIVE);
        ACDecomposer lDecIter = new ACDecomposer(lArgs);
        ACDecomposer rDecIter = new ACDecomposer(rArgs);
        long cnt = ((1L << lArgs.length - 1) - 1L) * ((1L << rArgs.length - 1) - 1L) * 2L;
        long skip = branchStack.branchesSkipCount(cnt);
        if (cnt < 0L || cnt > 1000000L) {
            this.logWarn("\nMore than one million branches are being generated by DecAC!");
        }
        for (ACDecomposer.ACDecomposition lDec : lDecIter) {
            currAup.left = FunctionApplication.instantiateFlatten(fncSymb, lDec.bucket0);
            newAup.left = FunctionApplication.instantiateFlatten(fncSymb, lDec.bucket1);
            for (ACDecomposer.ACDecomposition rDec : rDecIter) {
                if (skip >= 2L) {
                    skip -= 2L;
                    cnt -= 2L;
                    continue;
                }
                currAup.right = FunctionApplication.instantiateFlatten(fncSymb, rDec.bucket1);
                newAup.right = FunctionApplication.instantiateFlatten(fncSymb, rDec.bucket0);
                if (skip >= 1L) {
                    --skip;
                } else {
                    this.performDecBranch("DecAC new branch (position " + cnt + ")", currAup, newAup, cnt == 1L, currSys, branchStack);
                }
                NominalTerm tmpTerm = (NominalTerm)currAup.right;
                currAup.right = newAup.right;
                newAup.right = tmpTerm;
                this.performDecBranch("DecAC new branch (position " + --cnt + ")", currAup, newAup, cnt == 1L, currSys, branchStack);
                --cnt;
            }
        }
        if (cnt != 0L) {
            throw new IllegalStateException("Internal Error in branch iteration. This is a bug! We kindly ask you to report it and attach the input that caused this bug.");
        }
    }

    private void applyDecA(AntiUnifySystem currSys, int aupIdx, FunctionSymbol fncSymb, NominalTerm[] lArgs, NominalTerm[] rArgs, AntiUnifySystemStack branchStack) {
        AntiUnifyProblem currAup = (AntiUnifyProblem)currSys.problemSet.get(aupIdx);
        AntiUnifyProblem newAup = this.prepareDecBranch(currSys, aupIdx, currAup, fncSymb, lArgs, rArgs, false);
        long cnt = (lArgs.length - 1) * (rArgs.length - 1);
        long skip = branchStack.branchesSkipCount(cnt);
        if (cnt < 0L || cnt > 1000000L) {
            this.logWarn("\nMore than one million branches are being generated by DecA!");
        }
        for (int i = lArgs.length - 1; i >= 1; --i) {
            currAup.left = FunctionApplication.instantiateFlatten(fncSymb, Arrays.copyOfRange(lArgs, 0, i));
            newAup.left = FunctionApplication.instantiateFlatten(fncSymb, Arrays.copyOfRange(lArgs, i, lArgs.length));
            for (int j = rArgs.length - 1; j >= 1; --j) {
                if (skip >= 1L) {
                    --skip;
                } else {
                    currAup.right = FunctionApplication.instantiateFlatten(fncSymb, Arrays.copyOfRange(rArgs, 0, j));
                    newAup.right = FunctionApplication.instantiateFlatten(fncSymb, Arrays.copyOfRange(rArgs, j, rArgs.length));
                    this.performDecBranch("DecA new branch (position " + cnt + ")", currAup, newAup, cnt == 1L, currSys, branchStack);
                }
                --cnt;
            }
        }
        if (cnt != 0L) {
            throw new IllegalStateException("Internal Error in branch iteration. This is a bug! We kindly ask you to report it and attach the input that caused this bug.");
        }
    }

    private void applyDecC(AntiUnifySystem currSys, int aupIdx, FunctionSymbol fncSymb, NominalTerm[] lArgs, NominalTerm[] rArgs, AntiUnifySystemStack branchStack) {
        AntiUnifyProblem currAup = (AntiUnifyProblem)currSys.problemSet.get(aupIdx);
        AntiUnifyProblem newAup = this.prepareDecBranch(currSys, aupIdx, currAup, fncSymb, lArgs, rArgs, FunctionApplication.REARRANGE_COMMUTATIVE);
        currAup.set(lArgs[0], rArgs[1]);
        newAup.set(lArgs[1], rArgs[0]);
        currSys.problemSet.add(currAup);
        currSys.problemSet.add(newAup);
        if (!branchStack.isLimitExceeded() && branchStack.add(currSys.deepCopy())) {
            this.logRuleAppl("DecC new branch (position 2)", currSys);
        }
        currAup.right = rArgs[0];
        newAup.right = rArgs[1];
    }

    private void applyDec0(AntiUnifySystem currSys, int aupIdx, FunctionSymbol fncSymb, NominalTerm[] lArgs, NominalTerm[] rArgs) {
        AntiUnifyProblem currAup = (AntiUnifyProblem)currSys.problemSet.get(aupIdx);
        if (lArgs.length == 0) {
            currSys.sigma.composeInRange(currAup.generalizationVar, FunctionApplication.instantiateFlatten(fncSymb, new NominalTerm[0]));
            currSys.problemSet.remove(aupIdx, true);
        } else {
            Variable[] fresh = (Variable[])termVar.fresh2Symbols(lArgs.length);
            NominalTerm[] susps = (Suspension[])Arrays.stream(fresh).map(Suspension::new).toArray(Suspension[]::new);
            currSys.sigma.composeInRange(currAup.generalizationVar, FunctionApplication.instantiateFlatten(fncSymb, susps));
            currAup.set(fresh[0], lArgs[0], rArgs[0]);
            for (int i = 1; i < fresh.length; ++i) {
                AntiUnifyProblem newAup = new AntiUnifyProblem(lArgs[i], rArgs[i], fresh[i]);
                currSys.problemSet.add(newAup);
            }
        }
    }

    private AntiUnifyProblem prepareDecBranch(AntiUnifySystem currSys, int aupIdx, AntiUnifyProblem currAup, FunctionSymbol fncSymb, NominalTerm[] lArgs, NominalTerm[] rArgs, boolean rearrange) {
        Suspension susp1 = new Suspension((Variable)termVar.fresh2Symbol());
        Suspension susp2 = new Suspension((Variable)termVar.fresh2Symbol());
        currSys.sigma.composeInRange(currAup.generalizationVar, FunctionApplication.instantiateFlatten(fncSymb, susp1, susp2));
        currSys.problemSet.remove(aupIdx, true);
        currAup.generalizationVar = susp1.vari;
        if (rearrange) {
            Arrays.sort(lArgs);
            Arrays.sort(rArgs);
            Alignment a = this.rFnc.compute(lArgs, rArgs);
            this.doRearrange(lArgs, a.leftAligned);
            this.doRearrange(rArgs, a.rightAligned);
            this.logMsg(LVL_DEBUG, Arrays.toString(lArgs) + " / " + Arrays.toString(rArgs));
        }
        return new AntiUnifyProblem(NominalTerm.DUMMY, NominalTerm.DUMMY, susp2.vari);
    }

    private void doRearrange(NominalTerm[] args, Set<Integer> arranged) {
        ArrayList<NominalTerm> tmp = new ArrayList<NominalTerm>();
        int j = 0;
        for (int i = 0; i < args.length; ++i) {
            if (arranged.contains(i)) {
                args[j] = args[i];
                ++j;
                continue;
            }
            tmp.add(args[i]);
        }
        int start = j;
        while (j < args.length) {
            args[j] = (NominalTerm)tmp.get(j - start);
            ++j;
        }
    }

    private void performDecBranch(String ruleName, AntiUnifyProblem currAup, AntiUnifyProblem newAup, boolean isLast, AntiUnifySystem currSys, AntiUnifySystemStack branchStack) {
        if (isLast) {
            currSys.problemSet.add(currAup);
            currSys.problemSet.add(newAup);
        } else {
            AntiUnifySystem copySys = currSys.deepCopy();
            branchStack.add(copySys);
            copySys.problemSet.add(currAup.deepCopy());
            copySys.problemSet.add(newAup.deepCopy());
            this.logRuleAppl(ruleName, copySys);
        }
    }

    private boolean tryApplyAbs(AntiUnifySystem currSys, int aupIdx) {
        AntiUnifyProblem currAup = (AntiUnifyProblem)currSys.problemSet.get(aupIdx);
        Printable printable = currAup.left;
        if (printable instanceof Abstraction) {
            Abstraction lAbs = (Abstraction)printable;
            printable = currAup.right;
            if (printable instanceof Abstraction) {
                Abstraction rAbs = (Abstraction)printable;
                if (lAbs.boundAtom == rAbs.boundAtom) {
                    currSys.sigma.composeInRange(currAup.generalizationVar, new Abstraction(lAbs.boundAtom, new Suspension(currAup.generalizationVar)));
                    currAup.left = lAbs.subTerm;
                    currAup.right = rAbs.subTerm;
                } else {
                    Atom c = this.atoms.stream().filter(atom -> lAbs.isFresh((Atom)atom, currSys.nablaIn) && rAbs.isFresh((Atom)atom, currSys.nablaIn)).findFirst().orElse(null);
                    if (c == null) {
                        return false;
                    }
                    currSys.sigma.composeInRange(currAup.generalizationVar, new Abstraction(c, new Suspension(currAup.generalizationVar)));
                    currAup.left = lAbs.subTerm.swap(c, lAbs.boundAtom);
                    currAup.right = rAbs.subTerm.swap(c, rAbs.boundAtom);
                }
                this.logRuleAppl("Abs", currSys);
                return true;
            }
        }
        return false;
    }

    private void applySol(AntiUnifySystem currSys, int idx) {
        AntiUnifyProblem currAup = (AntiUnifyProblem)currSys.problemSet.remove(idx, true);
        for (Atom atom : this.atoms) {
            if (!((NominalTerm)currAup.left).isFresh(atom, currSys.nablaIn) || !((NominalTerm)currAup.right).isFresh(atom, currSys.nablaIn)) continue;
            currSys.nablaOut.put(atom, currAup.generalizationVar);
        }
        currSys.store.add(currAup);
        this.logRuleAppl("Sol", currSys);
    }

    private void logRuleAppl(String ruleName, AntiUnifySystem currSys) {
        this.logMsg(LVL_PROGRESS_AU, "\n ==> ", ruleName);
        this.logMsg(LVL_PROGRESS_AU, currSys);
    }
}

