/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.algo;

import cl.uoh.abaumgart.eqnauac.algo.AntiUnifyProblem;
import cl.uoh.abaumgart.eqnauac.algo.AntiUnifyProblemSequence;
import cl.uoh.abaumgart.eqnauac.algo.Substitution;
import cl.uoh.abaumgart.eqnauac.data.FreshnessCtx;
import cl.uoh.abaumgart.eqnauac.data.term.Suspension;
import cl.uoh.abaumgart.eqnauac.util.DeepCopyable;
import cl.uoh.abaumgart.eqnauac.util.Printable;
import java.io.IOException;
import java.io.Writer;

public class AntiUnifySystem
extends Printable
implements DeepCopyable<AntiUnifySystem> {
    public final AntiUnifyProblemSequence problemSet;
    public final AntiUnifyProblemSequence store;
    public final FreshnessCtx nablaIn;
    public final FreshnessCtx nablaOut;
    public final Substitution sigma;

    public AntiUnifySystem(AntiUnifyProblemSequence problemSet, AntiUnifyProblemSequence store, FreshnessCtx nablaIn, Substitution sigma) {
        this(problemSet, store, nablaIn, new FreshnessCtx(), sigma);
    }

    public AntiUnifySystem(AntiUnifyProblemSequence problemSet, AntiUnifyProblemSequence store, FreshnessCtx nablaIn, FreshnessCtx nablaOut, Substitution sigma) {
        this.problemSet = problemSet;
        this.store = store;
        this.nablaIn = nablaIn;
        this.nablaOut = nablaOut;
        this.sigma = sigma;
    }

    public AntiUnifySystem(AntiUnifyProblemSequence problemSet, FreshnessCtx nabla) {
        this(problemSet, new AntiUnifyProblemSequence(), nabla, new Substitution());
        for (AntiUnifyProblem aup : problemSet) {
            this.sigma.put(aup.generalizationVar, new Suspension(aup.generalizationVar));
        }
    }

    @Override
    public AntiUnifySystem deepCopy() {
        return new AntiUnifySystem(this.problemSet.deepCopy(), this.store.deepCopy(), this.nablaIn, this.nablaOut.deepCopy(), this.sigma.deepCopy());
    }

    @Override
    public void printString(Writer toPrint) throws IOException {
        this.problemSet.printString(toPrint.append("   Problem: "));
        this.store.printString(toPrint.append("\n     Store: "));
        this.nablaOut.printString(toPrint.append("\n     Nabla: "));
        this.sigma.printString(toPrint.append("\n     Sigma: "));
    }
}

