/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.algo;

import cl.uoh.abaumgart.eqnauac.algo.AntiUnifySystem;
import java.util.ArrayList;
import java.util.List;

public class AntiUnifySystemStack {
    private int branchLimit;
    private int branchCnt;
    private boolean limitExceeded;
    private List<AntiUnifySystem> systemsStack = new ArrayList<AntiUnifySystem>();

    public AntiUnifySystemStack(int branchLimit) {
        this.branchLimit = branchLimit;
    }

    public boolean add(AntiUnifySystem state) {
        if (this.branchLimit > -1) {
            if (this.branchCnt >= this.branchLimit) {
                this.limitExceeded = true;
                return false;
            }
            ++this.branchCnt;
        }
        this.systemsStack.add(state);
        return true;
    }

    public boolean isEmpty() {
        return this.systemsStack.isEmpty();
    }

    public AntiUnifySystem removeLast() {
        return this.systemsStack.removeLast();
    }

    public boolean isLimitExceeded() {
        return this.limitExceeded;
    }

    public long branchesSkipCount(long branchesRequested) {
        if (this.branchLimit < 0) {
            return 0L;
        }
        long maxPossible = this.branchLimit + 1 - this.branchCnt;
        if (branchesRequested > maxPossible) {
            this.limitExceeded = true;
            return branchesRequested - maxPossible;
        }
        return 0L;
    }
}

