/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.algo;

import cl.uoh.abaumgart.eqnauac.algo.EquivarianceApplicable;
import cl.uoh.abaumgart.eqnauac.algo.EquivarianceSystem;
import cl.uoh.abaumgart.eqnauac.data.term.Permutation;
import cl.uoh.abaumgart.eqnauac.util.VirtualLogging;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Equivariance
implements Iterable<Permutation>,
VirtualLogging {
    private final EquivarianceSystem eqProblem;
    private final EquivarianceApplicable algorithm;

    public Equivariance(EquivarianceSystem eqProblem, EquivarianceApplicable algorithm) {
        this.eqProblem = eqProblem;
        this.algorithm = algorithm;
    }

    @Override
    public Iterator<Permutation> iterator() {
        return new EquivarianceSystemIter(this.eqProblem.deepCopy());
    }

    public class EquivarianceSystemIter
    implements Iterator<Permutation> {
        private final List<EquivarianceSystem> eqSystems = new ArrayList<EquivarianceSystem>();
        private Permutation nextResult = null;

        public EquivarianceSystemIter(EquivarianceSystem sysIn) {
            this.eqSystems.add(sysIn);
        }

        @Override
        public boolean hasNext() {
            while (this.nextResult == null && !this.eqSystems.isEmpty()) {
                EquivarianceSystem nextSys = this.eqSystems.removeLast();
                Equivariance.this.logMsg(VirtualLogging.LVL_PROGRESS_EQ, "\nSelecting equivariance system:\n", nextSys);
                this.nextResult = Equivariance.this.algorithm.apply(nextSys, this.eqSystems);
                Equivariance.this.logMsg(VirtualLogging.LVL_PROGRESS_EQ, "Equivariance system evaluates to ", this.nextResult);
            }
            return this.nextResult != null;
        }

        @Override
        public Permutation next() {
            Permutation current = this.nextResult;
            this.nextResult = null;
            return current;
        }
    }
}

