/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.algo;

import cl.uoh.abaumgart.eqnauac.algo.EquivarianceApplicable;
import cl.uoh.abaumgart.eqnauac.algo.EquivarianceProblem;
import cl.uoh.abaumgart.eqnauac.algo.EquivarianceProblemSequence;
import cl.uoh.abaumgart.eqnauac.algo.EquivarianceSystem;
import cl.uoh.abaumgart.eqnauac.data.term.Abstraction;
import cl.uoh.abaumgart.eqnauac.data.term.Atom;
import cl.uoh.abaumgart.eqnauac.data.term.FunctionApplication;
import cl.uoh.abaumgart.eqnauac.data.term.FunctionSymbol;
import cl.uoh.abaumgart.eqnauac.data.term.NominalTerm;
import cl.uoh.abaumgart.eqnauac.data.term.Permutation;
import cl.uoh.abaumgart.eqnauac.data.term.Suspension;
import cl.uoh.abaumgart.eqnauac.data.term.TermSymbols;
import cl.uoh.abaumgart.eqnauac.data.term.Variable;
import cl.uoh.abaumgart.eqnauac.util.Printable;
import cl.uoh.abaumgart.eqnauac.util.VirtualLogging;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;

public class EquivarianceAlgorithm
implements EquivarianceApplicable,
TermSymbols,
VirtualLogging {
    @Override
    public Permutation apply(EquivarianceSystem currentSystem, List<EquivarianceSystem> systemsBranchStack) {
        if (!this.reduceAll(currentSystem, systemsBranchStack)) {
            return null;
        }
        return this.computePermutation(currentSystem);
    }

    private Permutation computePermutation(EquivarianceSystem currSys) {
        this.logMsg(LVL_DEBUG, "Starting phase 2 of equivariance algorithm (permutation phase)");
        Map<Atom, Atom> atomMap = currSys.mappings;
        Set<Atom> atoms = currSys.atoms;
        Permutation pi = new Permutation();
        for (Atom lAtom : currSys.atomList) {
            Atom rAtom = atomMap.remove(lAtom);
            if ((lAtom = pi.permute(lAtom)) == rAtom) {
                atoms.remove(lAtom);
                this.logRuleAppl("Rem-E", currSys);
                continue;
            }
            if (atoms.contains(lAtom) && atoms.remove(rAtom)) {
                pi.addSwappingHead(lAtom, rAtom);
                this.logRuleAppl("Sol-E", currSys);
                continue;
            }
            this.logMsg(LVL_DEBUG, "Permutation application not possible to " + String.valueOf(lAtom) + EquivarianceProblem.eqSeparator + String.valueOf(rAtom));
            return null;
        }
        return pi;
    }

    private boolean reduceAll(EquivarianceSystem currentSystem, Collection<EquivarianceSystem> systemsBranchStack) {
        this.logMsg(LVL_DEBUG, "Starting phase 1 of equivariance algorithm (simplification phase)");
        while (!currentSystem.problemSet.isEmpty()) {
            if (this.canAdvance((EquivarianceProblem)currentSystem.problemSet.removeLast(), currentSystem, systemsBranchStack)) continue;
            return false;
        }
        return true;
    }

    private boolean canAdvance(EquivarianceProblem currProblem, EquivarianceSystem currSys, Collection<EquivarianceSystem> sysBranchStack) {
        return this.tryApplyAtm(currProblem, currSys) || this.tryApplySus(currProblem, currSys) || this.tryApplyDec(currProblem, currSys, sysBranchStack) || this.tryApplyAbs(currProblem, currSys);
    }

    private boolean tryApplyAtm(EquivarianceProblem currProblem, EquivarianceSystem currSys) {
        Printable printable = currProblem.left;
        if (printable instanceof Atom) {
            Atom lAtm = (Atom)printable;
            printable = currProblem.right;
            if (printable instanceof Atom) {
                Atom rAtm = (Atom)printable;
                this.logRuleAppl("Rem-E", currSys);
                return this.putAtom(currSys, lAtm, rAtm);
            }
        }
        return false;
    }

    private boolean tryApplySus(EquivarianceProblem currProblem, EquivarianceSystem currSys) {
        Printable printable = currProblem.left;
        if (printable instanceof Suspension) {
            Suspension lSusp = (Suspension)printable;
            printable = currProblem.right;
            if (printable instanceof Suspension) {
                Suspension rSusp = (Suspension)printable;
                Variable lVar = lSusp.vari;
                if (lVar != rSusp.vari) {
                    return false;
                }
                Permutation lPerm = lSusp.perm;
                Permutation rPerm = rSusp.perm;
                this.logRuleAppl("Sus-E", currSys);
                for (Atom atom : currSys.atoms) {
                    if (currSys.nabla.contains(atom, lVar) || this.putAtom(currSys, lPerm.permute(atom), rPerm.permute(atom))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean putAtom(EquivarianceSystem currSys, Atom lAtom, Atom rAtom) {
        Atom oldVal = currSys.mappings.put(lAtom, rAtom);
        if (oldVal == null) {
            currSys.atomList.add(lAtom);
        } else if (oldVal != rAtom) {
            this.logMsg(LVL_DEBUG, "Swapping conflict: " + String.valueOf(lAtom) + EquivarianceProblem.eqSeparator + String.valueOf(oldVal) + "; " + String.valueOf(lAtom) + EquivarianceProblem.eqSeparator + String.valueOf(rAtom));
            return false;
        }
        return true;
    }

    private boolean tryApplyDec(EquivarianceProblem currProblem, EquivarianceSystem currSys, Collection<EquivarianceSystem> systemsBranchStack) {
        Printable printable = currProblem.left;
        if (printable instanceof FunctionApplication) {
            FunctionApplication lAppl = (FunctionApplication)printable;
            printable = currProblem.right;
            if (printable instanceof FunctionApplication) {
                FunctionApplication rAppl = (FunctionApplication)printable;
                if (lAppl.fncSymb.equals(rAppl.fncSymb) && lAppl.args.length == rAppl.args.length) {
                    FunctionSymbol fncSymb = lAppl.fncSymb;
                    int argsLen = lAppl.args.length;
                    if (fncSymbC.contains(fncSymb) && argsLen > 1) {
                        for (int i2 = argsLen - 1; i2 >= 1; --i2) {
                            EquivarianceSystem sysBranch = currSys.deepCopy();
                            this.doDecC(sysBranch.problemSet, lAppl.deepCopy(), rAppl.deepCopy(), i2);
                            this.logRuleAppl("Dec-E system branch", sysBranch);
                            systemsBranchStack.add(sysBranch);
                        }
                        this.doDecC(currSys.problemSet, lAppl, rAppl, 0);
                    } else {
                        currSys.problemSet.addAll(IntStream.range(0, argsLen).mapToObj(i -> new EquivarianceProblem(lAppl.args[i], rAppl.args[i])).toList().reversed());
                    }
                    this.logRuleAppl("Dec-E", currSys);
                    return true;
                }
            }
        }
        return false;
    }

    private void doDecC(EquivarianceProblemSequence problemSet, FunctionApplication lAppl, FunctionApplication rAppl, int idx) {
        NominalTerm t2;
        NominalTerm t1;
        EquivarianceProblem p0 = new EquivarianceProblem(lAppl.args[0], rAppl.args[idx]);
        int argsLen = lAppl.args.length;
        if (argsLen == 2) {
            t1 = lAppl.args[1];
            t2 = rAppl.args[1 - idx];
        } else {
            t1 = lAppl;
            t2 = rAppl;
            lAppl.args = Arrays.copyOfRange(lAppl.args, 1, argsLen);
            NominalTerm[] rArgs = Arrays.copyOfRange(rAppl.args, 1, argsLen);
            System.arraycopy(rAppl.args, 0, rArgs, 0, idx);
            rAppl.args = rArgs;
        }
        problemSet.add(new EquivarianceProblem(t1, t2));
        problemSet.add(p0);
    }

    private boolean tryApplyAbs(EquivarianceProblem currProblem, EquivarianceSystem currSys) {
        Printable printable = currProblem.left;
        if (printable instanceof Abstraction) {
            Abstraction lAbs = (Abstraction)printable;
            printable = currProblem.right;
            if (printable instanceof Abstraction) {
                Abstraction rAbs = (Abstraction)printable;
                Atom freshAtom = (Atom)atomSymb.freshTmpSymbol();
                currProblem.left = lAbs.subTerm.swap(lAbs.boundAtom, freshAtom);
                currProblem.right = rAbs.subTerm.swap(rAbs.boundAtom, freshAtom);
                currSys.problemSet.add(currProblem);
                this.logRuleAppl("Abs-E", currSys);
                return true;
            }
        }
        return false;
    }

    private void logRuleAppl(String ruleName, EquivarianceSystem currSys) {
        this.logMsg(LVL_PROGRESS_EQ, "\n ==> ", ruleName);
        this.logMsg(LVL_PROGRESS_EQ, currSys);
    }
}

