/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.algo;

import cl.uoh.abaumgart.eqnauac.algo.Alignment;
import cl.uoh.abaumgart.eqnauac.algo.RigidityFnc;
import cl.uoh.abaumgart.eqnauac.data.term.NominalTerm;
import cl.uoh.abaumgart.eqnauac.util.CoordList;
import cl.uoh.abaumgart.eqnauac.util.VirtualLogging;
import java.util.function.Consumer;

public class RigidityFncSubsequence
extends RigidityFnc {
    private int traceLenLeft = 32;
    private int traceLenRight = 32;
    private int[][] traceRoute = new int[this.traceLenLeft][this.traceLenRight];
    public static boolean DEBUG = false;

    @Override
    public Alignment compute(NominalTerm[] left, NominalTerm[] right) {
        int lenL = left.length;
        int lenR = right.length;
        if (this.traceLenLeft <= lenL || this.traceLenRight <= lenR) {
            if (this.traceLenLeft <= lenL) {
                this.traceLenLeft = lenL + 1;
            }
            if (this.traceLenRight <= lenR) {
                this.traceLenRight = lenR + 1;
            }
            this.traceRoute = new int[this.traceLenLeft][this.traceLenRight];
        }
        int[][] traceRoute = this.traceRoute;
        int MAX_VALUE = Integer.MAX_VALUE;
        int MIN_VALUE = Integer.MIN_VALUE;
        int[] prevLenI = traceRoute[0];
        int i = 0;
        while (i < lenL) {
            NominalTerm tLeft = left[i];
            int[] currLenI = traceRoute[++i];
            int j = 0;
            int prevLeft = 0;
            while (j < lenR) {
                int currLen;
                if (tLeft.getHead() == right[j].getHead()) {
                    prevLeft = (prevLenI[j] & MAX_VALUE) + 1;
                    currLen = prevLeft | MIN_VALUE;
                    ++j;
                } else {
                    int prevTop;
                    prevLeft = currLen = prevLeft > (prevTop = prevLenI[++j] & MAX_VALUE) ? prevLeft : prevTop;
                }
                currLenI[j] = currLen;
            }
            prevLenI = currLenI;
        }
        if (DEBUG) {
            this.debugMatrix(left, right, VirtualLogging.LOGGING_CONFIG.msgConsumer);
        }
        Alignment align = new Alignment();
        this.backTrack(align, traceRoute, left, lenL, lenR);
        return align;
    }

    protected void debugMatrix(NominalTerm[] left, NominalTerm[] right, Consumer<String> debugOut) {
        int lenL = left.length;
        int lenR = right.length;
        int MAX_VALUE = Integer.MAX_VALUE;
        int[][] traceRoute = this.traceRoute;
        debugOut.accept("Length matrix: (* signals a match)");
        StringBuilder out = new StringBuilder("    ");
        for (int j = 0; j < lenR; ++j) {
            out.append((" " + String.valueOf(right[j].getHead()) + "    ").substring(0, 5));
        }
        debugOut.accept(out.toString());
        out.setLength(0);
        for (int i = 1; i <= lenL; ++i) {
            out.append((String.valueOf(left[i - 1].getHead()) + "    ").substring(0, 4));
            for (int j = 1; j <= lenR; ++j) {
                if (j > 1) {
                    out.append(',');
                }
                int num = traceRoute[i][j] & MAX_VALUE;
                if (traceRoute[i][j] < 0) {
                    out.append('*');
                } else {
                    out.append(' ');
                }
                if (num < 100) {
                    if (num < 10) {
                        out.append('0');
                    }
                    out.append('0');
                }
                out.append(num);
            }
            debugOut.accept(out.toString());
            out.setLength(0);
        }
    }

    protected void backTrack(Alignment align, int[][] traceLen, NominalTerm[] left, int idxL, int idxR) {
        if (traceLen[idxL][idxR] == 0) {
            return;
        }
        CoordList exitList = CoordList.obtainList();
        this.findExits(traceLen, idxL, idxR, exitList);
        if (!exitList.isEmpty()) {
            int[] exit = (int[])exitList.getLast();
            idxL = exit[0];
            idxR = exit[1];
            this.backTrack(align, traceLen, left, idxL, idxR);
            align.addAtom(idxL, idxR);
        }
        exitList.free();
    }

    private void findExits(int[][] traceLen, int idxL, int idxT, CoordList result) {
        int MAX_VALUE = Integer.MAX_VALUE;
        int len = traceLen[idxL][idxT] & MAX_VALUE;
        int idxL1 = idxL - 1;
        int idxT1 = idxT - 1;
        boolean moveUp = true;
        CoordList branch = CoordList.obtainList();
        int i = 0;
        while (i >= 0) {
            if (traceLen[idxL][idxT] < 0 && !result.contains(idxL1, idxT1)) {
                result.add(idxL1, idxT1);
            }
            int walkLeft = traceLen[idxL1][idxT] & MAX_VALUE;
            int walkUp = MAX_VALUE;
            if (moveUp) {
                walkUp &= traceLen[idxL][idxT1];
            }
            if (walkLeft == len) {
                if (walkUp == len) {
                    ++i;
                    branch.add(idxL, idxT1);
                    moveUp = false;
                }
                idxL = idxL1--;
                continue;
            }
            if (walkUp == len) {
                idxT = idxT1--;
                continue;
            }
            if (i > 0) {
                int[] nextBranch = (int[])branch.getLast();
                idxL = nextBranch[0];
                idxT = nextBranch[1];
                idxL1 = idxL - 1;
                idxT1 = idxT - 1;
                branch.removeLast();
                moveUp = true;
            }
            --i;
        }
        branch.free();
    }
}

