/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.algo;

import cl.uoh.abaumgart.eqnauac.data.FreshnessCtx;
import cl.uoh.abaumgart.eqnauac.data.NominalPair;
import cl.uoh.abaumgart.eqnauac.data.term.NominalTerm;
import cl.uoh.abaumgart.eqnauac.data.term.Variable;
import cl.uoh.abaumgart.eqnauac.util.DeepCopyable;
import cl.uoh.abaumgart.eqnauac.util.Printable;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class Substitution
extends Printable
implements DeepCopyable<Substitution> {
    private Map<Variable, NominalTerm> mapping = new HashMap<Variable, NominalTerm>();
    public static String SIGMA_START = "{";
    public static String SIGMA_MAPTO = " -> ";
    public static String SIGMA_END = "} ";
    public static String RAN_PRINT_SEPARATOR = "; ";

    public void put(Variable fromVar, NominalTerm toTerm) {
        this.mapping.put(fromVar, toTerm);
    }

    public void composeInRange(Variable fromVar, NominalTerm toTerm) {
        for (Map.Entry<Variable, NominalTerm> e : this.mapping.entrySet()) {
            e.setValue(e.getValue().substitute(fromVar, toTerm));
        }
    }

    public NominalTerm get(Variable var) {
        return this.mapping.get(var);
    }

    public void clear() {
        this.mapping.clear();
    }

    @Override
    public Substitution deepCopy() {
        Substitution cpy = new Substitution();
        for (Map.Entry<Variable, NominalTerm> e : this.mapping.entrySet()) {
            cpy.mapping.put(e.getKey(), (NominalTerm)e.getValue().deepCopy());
        }
        return cpy;
    }

    public Map<Variable, NominalTerm> getMapping() {
        return this.mapping;
    }

    public void printRanString(Writer writer, FreshnessCtx nabla) throws IOException {
        boolean first = true;
        for (Map.Entry<Variable, NominalTerm> e : this.mapping.entrySet()) {
            if (first) {
                first = false;
            } else {
                writer.write(RAN_PRINT_SEPARATOR);
            }
            NominalPair.printPair(writer, nabla, e.getValue());
        }
    }

    @Override
    public void printString(Writer toPrint) throws IOException {
        for (Map.Entry<Variable, NominalTerm> e : this.mapping.entrySet()) {
            toPrint.append(SIGMA_START);
            e.getKey().printString(toPrint);
            toPrint.append(SIGMA_MAPTO);
            e.getValue().printString(toPrint);
            toPrint.append(SIGMA_END);
        }
    }
}

