/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.data;

import cl.uoh.abaumgart.eqnauac.data.Equation;
import cl.uoh.abaumgart.eqnauac.data.term.NominalTerm;
import cl.uoh.abaumgart.eqnauac.util.DeepCopyable;
import cl.uoh.abaumgart.eqnauac.util.Printable;
import java.io.IOException;
import java.io.Writer;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class EquationSystem<T extends Equation<?>>
extends Printable
implements DeepCopyable<EquationSystem<T>>,
Cloneable,
Iterable<T> {
    private Deque<T> equations = new LinkedList<T>();
    public static String EQ_SEPARATOR = ";  ";
    public static String EQ_PREFIX1 = null;
    public static String EQ_PREFIX2 = null;

    public abstract T newEquation(NominalTerm var1, NominalTerm var2);

    public int size() {
        return this.equations.size();
    }

    public boolean isEmpty() {
        return this.equations.isEmpty();
    }

    public void add(T equation) {
        this.equations.add(equation);
    }

    public void addFirst(T equation) {
        this.equations.addFirst(equation);
    }

    public T popFirst() {
        return (T)((Equation)this.equations.pollFirst());
    }

    public T popLast() {
        return (T)((Equation)this.equations.pollLast());
    }

    public T getFirst() {
        return (T)((Equation)this.equations.peekFirst());
    }

    public T getLast() {
        return (T)((Equation)this.equations.peekLast());
    }

    public void clear() {
        this.equations.clear();
    }

    @Override
    public Iterator<T> iterator() {
        return this.equations.iterator();
    }

    @Override
    public void printString(Writer toPrint) throws IOException {
        int i = 0;
        for (Equation elem : this.equations) {
            EquationSystem.writePrefix(toPrint, i);
            elem.printString(toPrint);
            ++i;
        }
    }

    public static void writePrefix(Writer toPrint, int i) throws IOException {
        if (EQ_SEPARATOR != null && i != 0) {
            toPrint.write(EQ_SEPARATOR);
        }
        if (EQ_PREFIX1 != null) {
            toPrint.write(EQ_PREFIX1);
        }
        if (EQ_PREFIX2 != null) {
            toPrint.write(String.valueOf(i + 1));
            toPrint.write(EQ_PREFIX2);
        }
    }

    @Override
    public EquationSystem<T> deepCopy() {
        try {
            EquationSystem ret = (EquationSystem)this.clone();
            LinkedList<T> eqNew = new LinkedList<T>();
            for (Equation eq : this.equations) {
                eqNew.add((Equation)eq.deepCopy());
            }
            ret.equations = eqNew;
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

