/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.data;

import cl.uoh.abaumgart.eqnauac.data.InputParser;
import cl.uoh.abaumgart.eqnauac.data.term.Abstraction;
import cl.uoh.abaumgart.eqnauac.data.term.Atom;
import cl.uoh.abaumgart.eqnauac.data.term.NominalTerm;
import cl.uoh.abaumgart.eqnauac.data.term.Suspension;
import cl.uoh.abaumgart.eqnauac.data.term.Variable;
import cl.uoh.abaumgart.eqnauac.util.DeepCopyable;
import cl.uoh.abaumgart.eqnauac.util.Printable;
import cl.uoh.abaumgart.eqnauac.util.Traversable;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FreshnessCtx
extends Printable
implements DeepCopyable<FreshnessCtx> {
    private Map<Atom, Set<Variable>> atomIdx;
    private Map<Variable, Set<Atom>> varIdx;

    public FreshnessCtx() {
        this(16, 16);
    }

    public FreshnessCtx(int sizeAtomIdx, int sizeVarIdx) {
        this.atomIdx = new HashMap<Atom, Set<Variable>>(sizeAtomIdx);
        this.varIdx = new HashMap<Variable, Set<Atom>>(sizeVarIdx);
    }

    public boolean contains(Atom atom, Variable var) {
        Set<Variable> freshIn = this.atomIdx.get(atom);
        return freshIn != null && freshIn.contains(var);
    }

    public boolean isEmpty() {
        return this.atomIdx.isEmpty();
    }

    public void put(Atom freshA, Collection<Variable> forVar) {
        this.put(freshA, forVar.toArray(new Variable[forVar.size()]));
    }

    public boolean isSubsetOf(FreshnessCtx other) {
        for (Map.Entry<Variable, Set<Atom>> entry : this.varIdx.entrySet()) {
            for (Atom atom : entry.getValue()) {
                if (other.contains(atom, entry.getKey())) continue;
                return false;
            }
        }
        return true;
    }

    public Set<Variable> get(Atom fresh) {
        Set<Variable> ret = this.atomIdx.get(fresh);
        if (ret == null) {
            return Collections.emptySet();
        }
        return ret;
    }

    public Set<Atom> get(Variable fresh) {
        Set<Atom> ret = this.varIdx.get(fresh);
        if (ret == null) {
            return Collections.emptySet();
        }
        return ret;
    }

    public void put(Atom freshA, Variable ... forVar) {
        Collections.addAll(this.createOrGet(freshA, this.atomIdx), forVar);
        for (Variable var : forVar) {
            this.createOrGet(var, this.varIdx).add(freshA);
        }
    }

    public void put(Variable forVar, Collection<Atom> freshA) {
        this.put(forVar, freshA.toArray(new Atom[freshA.size()]));
    }

    public void put(Variable forVar, Atom ... freshA) {
        Collections.addAll(this.createOrGet(forVar, this.varIdx), freshA);
        for (Atom atom : freshA) {
            this.createOrGet(atom, this.atomIdx).add(forVar);
        }
    }

    private <K, V> Set<V> createOrGet(K key, Map<K, Set<V>> map) {
        Set<V> valueSet = map.get(key);
        if (valueSet == null) {
            valueSet = new HashSet<V>();
            map.put(key, valueSet);
        }
        return valueSet;
    }

    public void remove(Atom freshA, Variable forVar) {
        this.removeIfExists(this.atomIdx, freshA, forVar);
        this.removeIfExists(this.varIdx, forVar, freshA);
    }

    public Set<Atom> removeAll(Variable var) {
        Set<Atom> freshIn = this.varIdx.remove(var);
        if (freshIn == null) {
            return Collections.emptySet();
        }
        for (Atom atom : freshIn) {
            this.removeIfExists(this.atomIdx, atom, var);
        }
        return freshIn;
    }

    public Set<Variable> removeAll(Atom atom) {
        Set<Variable> freshIn = this.atomIdx.remove(atom);
        if (freshIn == null) {
            return Collections.emptySet();
        }
        for (Variable var : freshIn) {
            this.removeIfExists(this.varIdx, var, atom);
        }
        return freshIn;
    }

    private <K, V> void removeIfExists(Map<K, Set<V>> map, K key, V value) {
        Set<V> vars = map.get(key);
        if (vars != null) {
            vars.remove(value);
            if (vars.isEmpty()) {
                map.remove(key);
            }
        }
    }

    public Set<Atom> allAtoms() {
        return this.atomIdx.keySet();
    }

    @Override
    public void printString(Writer toPrint) throws IOException {
        toPrint.write(InputParser.cp_nablaStart);
        boolean sep = false;
        for (Map.Entry<Variable, Set<Atom>> fresh : this.varIdx.entrySet()) {
            String var = fresh.getKey().toString();
            for (Atom atom : fresh.getValue()) {
                if (sep) {
                    toPrint.write(InputParser.cp_nablaSeparator);
                } else {
                    sep = true;
                }
                atom.printString(toPrint);
                toPrint.write(InputParser.cp_fresh);
                toPrint.write(var);
            }
        }
        toPrint.write(InputParser.cp_nablaEnd);
    }

    @Override
    public FreshnessCtx deepCopy() {
        FreshnessCtx ret = new FreshnessCtx(this.atomIdx.size(), this.varIdx.size());
        for (Map.Entry<Atom, Set<Variable>> entry : this.atomIdx.entrySet()) {
            ret.put(entry.getKey(), (Collection<Variable>)entry.getValue());
        }
        return ret;
    }

    public FreshnessCtx swap(Atom a, Atom b) {
        FreshnessCtx ret = new FreshnessCtx(this.atomIdx.size(), this.varIdx.size());
        for (Map.Entry<Atom, Set<Variable>> entry : this.atomIdx.entrySet()) {
            ret.put(entry.getKey().swap(a, b), (Collection<Variable>)entry.getValue());
        }
        return ret;
    }

    public void addFreshConstraint(final Atom atom, NominalTerm ... nomTerms) {
        Traversable.TraverseCallBack<NominalTerm> callBack = new Traversable.TraverseCallBack<NominalTerm>(){

            @Override
            public boolean exec(NominalTerm term) {
                if (term instanceof Suspension) {
                    Suspension susp = (Suspension)term;
                    FreshnessCtx.this.put(susp.vari, susp.perm.permuteInverse(atom));
                    return true;
                }
                if (term instanceof Abstraction) {
                    Abstraction abs = (Abstraction)term;
                    return abs.getBoundAtom() == atom;
                }
                return false;
            }
        };
        for (NominalTerm term : nomTerms) {
            term.traverse(callBack);
        }
    }

    public void substitute(Variable fromVar, NominalTerm toTerm) {
        for (Atom atom : this.removeAll(fromVar)) {
            this.addFreshConstraint(atom, toTerm);
        }
    }
}

