/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.data;

import cl.uoh.abaumgart.eqnauac.algo.AntiUnifyProblem;
import cl.uoh.abaumgart.eqnauac.data.Equation;
import cl.uoh.abaumgart.eqnauac.data.EquationSystem;
import cl.uoh.abaumgart.eqnauac.data.FreshnessCtx;
import cl.uoh.abaumgart.eqnauac.data.NominalPair;
import cl.uoh.abaumgart.eqnauac.data.term.Abstraction;
import cl.uoh.abaumgart.eqnauac.data.term.Atom;
import cl.uoh.abaumgart.eqnauac.data.term.FunctionApplication;
import cl.uoh.abaumgart.eqnauac.data.term.FunctionSymbol;
import cl.uoh.abaumgart.eqnauac.data.term.NominalTerm;
import cl.uoh.abaumgart.eqnauac.data.term.Permutation;
import cl.uoh.abaumgart.eqnauac.data.term.Suspension;
import cl.uoh.abaumgart.eqnauac.data.term.TermSymbols;
import cl.uoh.abaumgart.eqnauac.data.term.Variable;
import cl.uoh.abaumgart.eqnauac.util.ControlledException;
import cl.uoh.abaumgart.eqnauac.util.EquationSequence;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class InputParser
implements TermSymbols {
    public static int cp_separator1 = 44;
    public static int cp_separator2 = 59;
    public static int cp_separator3 = 124;
    public static int cp_argsStart = 40;
    public static int cp_argsSeparator = cp_separator1;
    public static int cp_argsEnd = 41;
    public static int cp_swapStart = 40;
    public static int cp_swapEnd = 41;
    public static int cp_nablaStart = 123;
    public static int cp_nablaSeparator = cp_separator1;
    public static int cp_nablaEnd = 125;
    public static int cp_abstraction = 46;
    public static int cp_fresh = 35;
    public static int cp_atomFrom = 97;
    public static int cp_atomTo = 101;
    public static int cp_varFrom = 117;
    public static int cp_varTo = 122;
    public static int cp_equationSuffix1 = 63;
    public static int cp_equationSuffix2 = 33;
    public static int cp_equationSuffix3 = 94;
    private int nextCodePoint;

    public InputParser() {
        this.reset();
    }

    public NominalPair parsePair(Reader nablaIn, Reader termIn) throws ParseException, IOException {
        return new NominalPair(this.parseNabla(nablaIn), this.parseTerm(termIn, true));
    }

    public FreshnessCtx parseNabla(Reader in) throws IOException, ParseException {
        FreshnessCtx nabla = new FreshnessCtx();
        while (this.nextNameChar(in)) {
            NameInfo nameI = this.nextName(in);
            if (this.nextCodePoint != cp_fresh || !InputParser.isNameChar(this.nextSymbol(in))) {
                throw new ParseException("Malformed freshness context");
            }
            nabla.put(this.createAtom(nameI), (Variable)termVar.parseSymbol(this.nextName((Reader)in).name));
        }
        this.reset();
        return nabla;
    }

    private boolean nextNameChar(Reader in) throws IOException {
        while (!InputParser.isNameChar(this.nextSymbol(in))) {
            if (this.nextCodePoint != -1) continue;
            return false;
        }
        return true;
    }

    public <T extends Equation<NominalTerm>> void parseEquationSystem(Reader in, EquationSequence<NominalTerm, T> eqSys) throws IOException, ControlledException {
        do {
            NominalTerm left;
            if ((left = this.parseTerm(in, false)) == null) {
                return;
            }
            this.parseEquationSeparator(in);
            NominalTerm right = this.parseTerm(in, false);
            if (right == null) {
                throw new ParseException("Malformed equation system");
            }
            eqSys.addNewEquation(left, right);
            while (!this.isEqSeparatorChar(this.nextCodePoint)) {
                if (InputParser.isNameChar(this.nextCodePoint)) {
                    throw new ParseException("Malformed equation system");
                }
                this.nextSymbol(in);
            }
        } while (this.nextSymbol(in) != -1);
        this.reset();
    }

    public <T extends Equation<NominalTerm>> void parseEquation(Reader in1, Reader in2, EquationSystem<T> eqSys) throws ParseException, IOException {
        eqSys.newEquation(this.parseTerm(in1, true), this.parseTerm(in2, true));
    }

    public FreshnessCtx parseEquationAndCtx(Reader in1, Reader in2, Reader inN, EquationSystem<AntiUnifyProblem> eqSys) throws ParseException, IOException {
        this.parseEquation(in1, in2, eqSys);
        return this.parseNabla(inN);
    }

    private void parseEquationSeparator(Reader in) throws ParseException, IOException {
        while (!this.isEquationSign(this.nextCodePoint)) {
            if (this.nextCodePoint == -1) {
                throw new ParseException("Right hand side of equation is missing");
            }
            if (InputParser.isNameChar(this.nextCodePoint)) {
                throw new ParseException("Malformed equation");
            }
            this.nextSymbol(in);
        }
        do {
            this.nextSymbol(in);
        } while (this.isEquationSeparatorSuffix());
    }

    private boolean isEquationSign(int codePoint) {
        return codePoint == 8793 || codePoint == 8849 || codePoint == 61;
    }

    protected boolean isEqSeparatorChar(int codePoint) {
        return codePoint == cp_separator1 || codePoint == cp_separator2 || codePoint == cp_separator3 || codePoint == -1;
    }

    protected boolean isEquationSeparatorSuffix() {
        return this.nextCodePoint == cp_equationSuffix1 || this.nextCodePoint == cp_equationSuffix2 || this.isEquationSign(this.nextCodePoint) || this.nextCodePoint == cp_equationSuffix3;
    }

    public NominalTerm parseTerm(Reader in, boolean reset) throws ParseException, IOException {
        NominalTerm nomTerm = this.parseTermIntern(in, false);
        if (reset) {
            this.reset();
        }
        return nomTerm;
    }

    private NominalTerm parseTermIntern(Reader in, boolean mandatory) throws IOException, ParseException {
        while (!InputParser.isNameChar(this.nextCodePoint) && !InputParser.isSwapStart(this.nextCodePoint)) {
            if (this.nextSymbol(in) != -1) continue;
            if (mandatory) {
                throw new ParseException("Malformed nominal term");
            }
            return null;
        }
        if (InputParser.isSwapStart(this.nextCodePoint)) {
            Permutation perm = new Permutation();
            while (InputParser.isSwapStart(this.nextCodePoint)) {
                perm.addSwappingTail(this.createAtom(this.nextName(in)), this.createAtom(this.nextName(in)));
                if (!InputParser.isSwapEnd(this.nextCodePoint)) {
                    throw new ParseException("Malformed swapping");
                }
                this.nextSymbol(in);
            }
            return this.createSuspension(perm, this.nextName(in));
        }
        NameInfo nameInfo = this.nextName(in);
        switch (nameInfo.symbType.ordinal()) {
            case 0: {
                if (this.nextCodePoint == cp_abstraction) {
                    Atom oldAtom = this.createAtom(nameInfo);
                    NominalTerm nomTerm = this.parseTermIntern(in, true);
                    return new Abstraction(oldAtom, nomTerm);
                }
                return this.createAtom(nameInfo);
            }
            case 2: {
                return this.createSuspension(new Permutation(), nameInfo);
            }
            case 1: {
                ArrayList<NominalTerm> args = null;
                if (InputParser.isArgsStart(this.nextCodePoint) && !InputParser.isArgsEnd(this.nextSymbol(in))) {
                    args = new ArrayList<NominalTerm>();
                    while (!InputParser.isArgsEnd(this.nextCodePoint) && this.nextCodePoint != -1) {
                        args.add(this.parseTermIntern(in, true));
                    }
                }
                this.nextSymbol(in);
                return this.createFunction(nameInfo, args);
            }
        }
        return null;
    }

    private NominalTerm createFunction(NameInfo nameI, List<NominalTerm> args) throws ParseException {
        if (nameI.symbType != NameInfo.SymbType.FNC) {
            throw new ParseException("Invalid name for a function: " + nameI.name);
        }
        return FunctionApplication.instantiateFlattenRearrange((FunctionSymbol)fncSymb.parseSymbol(nameI.name), args);
    }

    private Atom createAtom(NameInfo nameI) throws ParseException {
        if (nameI.symbType != NameInfo.SymbType.ATOM) {
            throw new ParseException("Invalid name for an symbol: " + nameI.name);
        }
        return (Atom)atomSymb.parseSymbol(nameI.name);
    }

    private NominalTerm createSuspension(Permutation perm, NameInfo nameI) throws ParseException {
        if (nameI.symbType != NameInfo.SymbType.SUSP) {
            throw new ParseException("Invalid name for a suspension: " + nameI.name);
        }
        String name = nameI.name;
        return new Suspension((Variable)termVar.parseSymbol(name), perm);
    }

    protected static boolean isSortData(String sort) {
        return Character.isUpperCase(sort.codePointAt(0));
    }

    private NameInfo nextName(Reader in) throws IOException, ParseException {
        while (!InputParser.isNameChar(this.nextCodePoint)) {
            if (this.nextSymbol(in) != -1) continue;
            throw new ParseException("Unexpected end of term");
        }
        StringBuilder name = new StringBuilder();
        do {
            name.appendCodePoint(this.nextCodePoint);
            this.nextCodePoint = in.read();
        } while (InputParser.isNameChar(this.nextCodePoint));
        NameInfo currentName = new NameInfo(name.toString());
        while (Character.isWhitespace(this.nextCodePoint)) {
            this.nextSymbol(in);
        }
        if (this.nextCodePoint != 40 && this.nextCodePoint != 91) {
            int firstChar = Character.toLowerCase(currentName.name.codePointAt(0));
            if (firstChar >= cp_varFrom && firstChar <= cp_varTo) {
                currentName.symbType = NameInfo.SymbType.SUSP;
            } else if (firstChar >= cp_atomFrom && firstChar <= cp_atomTo) {
                currentName.symbType = NameInfo.SymbType.ATOM;
            }
        }
        return currentName;
    }

    public static boolean isArgsStart(int codePoint) {
        return codePoint == cp_argsStart || codePoint == 40 || codePoint == 91;
    }

    public static boolean isArgsEnd(int codePoint) {
        return codePoint == cp_argsEnd || codePoint == 41 || codePoint == 93;
    }

    public static boolean isSwapStart(int codePoint) {
        return codePoint == cp_swapStart;
    }

    public static boolean isSwapEnd(int codePoint) {
        return codePoint == cp_swapEnd;
    }

    private int nextSymbol(Reader in) throws IOException {
        do {
            this.nextCodePoint = in.read();
        } while (Character.isWhitespace(this.nextCodePoint));
        return this.nextCodePoint;
    }

    public static boolean isNameChar(int codePoint) {
        return Character.isUnicodeIdentifierPart(codePoint) || codePoint == 43 || codePoint == 45 || codePoint == 42 || codePoint == 47 || codePoint == 95 || codePoint == 64;
    }

    public void reset() {
        this.nextCodePoint = -2;
    }

    static class NameInfo {
        String name;
        SymbType symbType = SymbType.FNC;

        NameInfo(String name) {
            this.name = name;
        }

        static enum SymbType {
            ATOM,
            FNC,
            SUSP;

        }
    }

    public class ParseException
    extends ControlledException {
        static final long serialVersionUID = 1370936169201259463L;

        ParseException(String message) {
            super(message);
        }
    }
}

