/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.data;

import cl.uoh.abaumgart.eqnauac.data.FreshnessCtx;
import cl.uoh.abaumgart.eqnauac.data.term.Atom;
import cl.uoh.abaumgart.eqnauac.data.term.NominalTerm;
import cl.uoh.abaumgart.eqnauac.data.term.Variable;
import cl.uoh.abaumgart.eqnauac.util.DeepCopyable;
import cl.uoh.abaumgart.eqnauac.util.Printable;
import java.io.IOException;
import java.io.Writer;

public class NominalPair
extends Printable
implements DeepCopyable<NominalPair> {
    private FreshnessCtx freshEnv;
    private NominalTerm term;
    public static String pairStart = "<";
    public static String pairSeparator = "; ";
    public static String pairEnd = ">";

    public NominalPair(NominalTerm term) {
        this(new FreshnessCtx(), term);
    }

    public NominalPair(FreshnessCtx freshEnv, NominalTerm term) {
        this.freshEnv = freshEnv;
        this.term = term;
    }

    public FreshnessCtx getFreshEnv() {
        return this.freshEnv;
    }

    public void setFreshEnv(FreshnessCtx freshEnv) {
        this.freshEnv = freshEnv;
    }

    public NominalTerm getTerm() {
        return this.term;
    }

    public void setTerm(NominalTerm term) {
        this.term = term;
    }

    public void swap(Atom a1, Atom a2) {
        this.freshEnv = this.freshEnv.swap(a1, a2);
        this.term = this.term.swap(a1, a2);
    }

    @Override
    public void printString(Writer toPrint) throws IOException {
        NominalPair.printPair(toPrint, this.freshEnv, this.term);
    }

    public static void printPair(Writer toPrint, FreshnessCtx freshEnv, NominalTerm term) throws IOException {
        toPrint.write(pairStart);
        freshEnv.printString(toPrint);
        toPrint.write(pairSeparator);
        toPrint.write(32);
        term.printString(toPrint);
        toPrint.write(pairEnd);
    }

    @Override
    public NominalPair deepCopy() {
        return new NominalPair(this.freshEnv.deepCopy(), (NominalTerm)this.term.deepCopy());
    }

    public boolean prooveFresh(Atom atom) {
        return this.term.isFresh(atom, this.freshEnv);
    }

    public void substitute(Variable fromVar, NominalTerm toTerm) {
        this.freshEnv.substitute(fromVar, toTerm);
        this.term = this.term.substitute(fromVar, toTerm);
    }
}

