/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.data.term;

import cl.uoh.abaumgart.eqnauac.data.FreshnessCtx;
import cl.uoh.abaumgart.eqnauac.data.InputParser;
import cl.uoh.abaumgart.eqnauac.data.term.Atom;
import cl.uoh.abaumgart.eqnauac.data.term.NominalTerm;
import cl.uoh.abaumgart.eqnauac.data.term.Permutation;
import cl.uoh.abaumgart.eqnauac.data.term.Symbol;
import cl.uoh.abaumgart.eqnauac.data.term.TermSymbols;
import cl.uoh.abaumgart.eqnauac.data.term.Variable;
import cl.uoh.abaumgart.eqnauac.util.Traversable;
import java.io.IOException;
import java.io.Writer;

public class Abstraction
extends NominalTerm {
    public Atom boundAtom;
    public NominalTerm subTerm;

    public Abstraction(Atom boundAtom, NominalTerm subTerm) {
        this.boundAtom = boundAtom;
        this.subTerm = subTerm;
    }

    public boolean equals(Object other) {
        if (other instanceof Abstraction) {
            Abstraction oAbs = (Abstraction)other;
            return oAbs.boundAtom == this.boundAtom && oAbs.subTerm.equals(this.subTerm);
        }
        return false;
    }

    public Atom getBoundAtom() {
        return this.boundAtom;
    }

    public void setBoundAtom(Atom boundAtom) {
        this.boundAtom = boundAtom;
    }

    public NominalTerm getSubTerm() {
        return this.subTerm;
    }

    public void setSubTerm(NominalTerm subTerm) {
        this.subTerm = subTerm;
    }

    @Override
    public void printString(Writer toPrint) throws IOException {
        toPrint.write(this.boundAtom.toString());
        toPrint.write(InputParser.cp_abstraction);
        this.subTerm.printString(toPrint);
    }

    @Override
    public NominalTerm swap(Atom a1, Atom a2) {
        this.boundAtom = this.boundAtom.swap(a1, a2);
        this.subTerm = this.subTerm.swap(a1, a2);
        return this;
    }

    @Override
    protected boolean propagate(Traversable.TraverseCallBack<NominalTerm> callBack) {
        return this.subTerm.traverse(callBack);
    }

    @Override
    public boolean isFresh(Atom atom, FreshnessCtx nabla) {
        if (atom == this.boundAtom) {
            return true;
        }
        return this.subTerm.isFresh(atom, nabla);
    }

    @Override
    public Abstraction deepCopy() {
        return new Abstraction(this.boundAtom, (NominalTerm)this.subTerm.deepCopy());
    }

    @Override
    public NominalTerm substitute(Variable fromVar, NominalTerm toTerm) {
        this.subTerm = this.subTerm.substitute(fromVar, toTerm);
        return this;
    }

    @Override
    public Abstraction permute(Permutation perm) {
        this.boundAtom = this.boundAtom.permute(perm);
        this.subTerm = this.subTerm.permute(perm);
        return this;
    }

    @Override
    public Symbol getHead() {
        return Symbol.DUMMY;
    }

    @Override
    public int getTypeOrdinal() {
        return 40;
    }

    @Override
    public int compareTo(NominalTerm o) {
        if (o instanceof Abstraction) {
            Abstraction oAbs = (Abstraction)o;
            Atom c = TermSymbols.atomSymb.freshTmpSymbol();
            return ((NominalTerm)this.subTerm.deepCopy()).swap(c, this.boundAtom).compareTo(((NominalTerm)oAbs.subTerm.deepCopy()).swap(c, oAbs.boundAtom));
        }
        return super.compareTo(o);
    }
}

