/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.data.term;

import cl.uoh.abaumgart.eqnauac.data.FreshnessCtx;
import cl.uoh.abaumgart.eqnauac.data.InputParser;
import cl.uoh.abaumgart.eqnauac.data.term.Atom;
import cl.uoh.abaumgart.eqnauac.data.term.FunctionSymbol;
import cl.uoh.abaumgart.eqnauac.data.term.NominalTerm;
import cl.uoh.abaumgart.eqnauac.data.term.Permutation;
import cl.uoh.abaumgart.eqnauac.data.term.Symbol;
import cl.uoh.abaumgart.eqnauac.data.term.TermSymbols;
import cl.uoh.abaumgart.eqnauac.data.term.Variable;
import cl.uoh.abaumgart.eqnauac.util.DeepCopyable;
import cl.uoh.abaumgart.eqnauac.util.Traversable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class FunctionApplication
extends NominalTerm
implements TermSymbols {
    public FunctionSymbol fncSymb;
    public NominalTerm[] args;
    public static boolean REARRANGE_COMMUTATIVE = true;
    private static final NominalTerm[] emptyArgs = new NominalTerm[0];

    private FunctionApplication(FunctionSymbol fncSymb) {
        this(fncSymb, emptyArgs);
    }

    private FunctionApplication(FunctionSymbol fncSymb, Collection<NominalTerm> args) {
        this(fncSymb, args == null ? emptyArgs : args.toArray(emptyArgs));
    }

    private FunctionApplication(FunctionSymbol fncSymb, NominalTerm ... args) {
        if (args == null || args.length == 0) {
            args = emptyArgs;
        }
        this.fncSymb = fncSymb;
        this.args = args;
    }

    public static NominalTerm instantiateFlattenRearrange(FunctionSymbol fncSymb, Collection<NominalTerm> args) {
        return new FunctionApplication(fncSymb, args).flattenAndRearrange(REARRANGE_COMMUTATIVE);
    }

    public static NominalTerm instantiateFlattenRearrange(FunctionSymbol fncSymb, NominalTerm ... args) {
        return new FunctionApplication(fncSymb, args).flattenAndRearrange(REARRANGE_COMMUTATIVE);
    }

    public static NominalTerm instantiateFlatten(FunctionSymbol fncSymb, Collection<NominalTerm> args) {
        return new FunctionApplication(fncSymb, args).flattenAndRearrange(false);
    }

    public static NominalTerm instantiateFlatten(FunctionSymbol fncSymb, NominalTerm ... args) {
        return new FunctionApplication(fncSymb, args).flattenAndRearrange(false);
    }

    public boolean equals(Object other) {
        if (other instanceof FunctionApplication) {
            FunctionApplication oApp = (FunctionApplication)other;
            return oApp.fncSymb == this.fncSymb && oApp.args.equals(this.args);
        }
        return false;
    }

    public FunctionSymbol getFncSymb() {
        return this.fncSymb;
    }

    public NominalTerm[] getArgs() {
        return this.args;
    }

    @Override
    public void printString(Writer writer) throws IOException {
        writer.write(this.fncSymb.toString());
        int len = this.args.length;
        if (len > 0) {
            writer.write(InputParser.cp_argsStart);
            this.args[0].printString(writer);
            for (int i = 1; i < len; ++i) {
                writer.write(InputParser.cp_argsSeparator);
                writer.write(32);
                this.args[i].printString(writer);
            }
            writer.write(InputParser.cp_argsEnd);
        }
    }

    @Override
    public NominalTerm swap(Atom a1, Atom a2) {
        for (int i = this.args.length - 1; i >= 0; --i) {
            this.args[i] = this.args[i].swap(a1, a2);
        }
        return this;
    }

    @Override
    protected boolean propagate(Traversable.TraverseCallBack<NominalTerm> callBack) {
        int n = this.args.length;
        for (int i = 0; i < n; ++i) {
            if (!this.args[i].traverse(callBack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFresh(Atom atom, FreshnessCtx nabla) {
        for (NominalTerm arg : this.args) {
            if (arg.isFresh(atom, nabla)) continue;
            return false;
        }
        return true;
    }

    @Override
    public FunctionApplication deepCopy() {
        if (this.args.length == 0) {
            return new FunctionApplication(this.fncSymb, emptyArgs);
        }
        NominalTerm[] tmp = (NominalTerm[])Arrays.stream(this.args).map(DeepCopyable::deepCopy).toArray(NominalTerm[]::new);
        return new FunctionApplication(this.fncSymb, tmp);
    }

    @Override
    public NominalTerm substitute(Variable fromVar, NominalTerm toTerm) {
        for (int i = this.args.length - 1; i >= 0; --i) {
            this.args[i] = this.args[i].substitute(fromVar, toTerm);
        }
        return this.flattenAndRearrange(false);
    }

    @Override
    public NominalTerm permute(Permutation perm) {
        for (int i = this.args.length - 1; i >= 0; --i) {
            this.args[i] = this.args[i].permute(perm);
        }
        return this;
    }

    @Override
    public Symbol getHead() {
        return this.fncSymb;
    }

    public NominalTerm flattenAndRearrange(boolean rearrange) {
        if (this.needsFlatten()) {
            if (this.args.length == 1) {
                return this.args[0];
            }
            this.doFlatten();
        }
        if (rearrange && this.needsRearrange()) {
            Arrays.sort(this.args);
        }
        return this;
    }

    private void doFlatten() {
        ArrayList<NominalTerm> argsFlattened = new ArrayList<NominalTerm>(this.args.length + 16);
        for (NominalTerm arg : this.args) {
            if (arg instanceof FunctionApplication) {
                FunctionApplication otherAppl = (FunctionApplication)arg;
                if (this.fncSymb == otherAppl.fncSymb) {
                    Collections.addAll(argsFlattened, otherAppl.args);
                    continue;
                }
            }
            argsFlattened.add(arg);
        }
        this.args = (NominalTerm[])argsFlattened.toArray(NominalTerm[]::new);
    }

    private boolean needsFlatten() {
        if (!fncSymbA.contains(this.fncSymb)) {
            return false;
        }
        if (this.args.length == 1) {
            return true;
        }
        for (NominalTerm arg : this.args) {
            if (!(arg instanceof FunctionApplication)) continue;
            FunctionApplication otherAppl = (FunctionApplication)arg;
            if (this.fncSymb != otherAppl.fncSymb) continue;
            return true;
        }
        return false;
    }

    private boolean needsRearrange() {
        return this.args.length > 1 && fncSymbC.contains(this.fncSymb);
    }

    @Override
    public int getTypeOrdinal() {
        return 20;
    }

    @Override
    public int compareTo(NominalTerm o) {
        int cmp = super.compareTo(o);
        if (cmp == 0 && o instanceof FunctionApplication) {
            FunctionApplication oFnc = (FunctionApplication)o;
            int i = 0;
            while (cmp == 0) {
                if (i == this.args.length) {
                    return i == oFnc.args.length ? 0 : -1;
                }
                if (i == oFnc.args.length) {
                    return 1;
                }
                cmp = this.args[i].compareTo(oFnc.args[i]);
                ++i;
            }
        }
        return cmp;
    }
}

