/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.data.term;

import cl.uoh.abaumgart.eqnauac.data.FreshnessCtx;
import cl.uoh.abaumgart.eqnauac.data.InputParser;
import cl.uoh.abaumgart.eqnauac.data.term.Atom;
import cl.uoh.abaumgart.eqnauac.data.term.Variable;
import cl.uoh.abaumgart.eqnauac.util.DeepCopyable;
import cl.uoh.abaumgart.eqnauac.util.Printable;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Permutation
extends Printable
implements DeepCopyable<Permutation> {
    private Map<Atom, Atom> perm;
    private Map<Atom, Atom> invs;
    public static String idString = "Id";

    public Permutation() {
        this(10);
    }

    protected Permutation(Map<Atom, Atom> perm, Map<Atom, Atom> invs) {
        this.perm = new HashMap<Atom, Atom>(perm);
        this.invs = new HashMap<Atom, Atom>(invs);
    }

    public Permutation(int initSize) {
        this.perm = new HashMap<Atom, Atom>(initSize);
        this.invs = new HashMap<Atom, Atom>(initSize);
    }

    public void addSwappingHead(Atom a1, Atom a2) {
        this.addSwapping(this.perm, this.invs, a1, a2);
    }

    public void addSwappingTail(Atom a1, Atom a2) {
        this.addSwapping(this.invs, this.perm, a1, a2);
    }

    private void addSwapping(Map<Atom, Atom> from, Map<Atom, Atom> to, Atom a, Atom b) {
        Atom c = to.get(a);
        Atom d = to.get(b);
        if (c == b) {
            from.remove(c);
            to.remove(b);
        } else if (c != null) {
            from.put(c, b);
            to.put(b, c);
        } else {
            from.put(a, b);
            to.put(b, a);
        }
        if (d == a) {
            from.remove(d);
            to.remove(a);
        } else if (d != null) {
            from.put(d, a);
            to.put(a, d);
        } else {
            from.put(b, a);
            to.put(a, b);
        }
    }

    public Atom permute(Atom key) {
        Atom target = this.perm.get(key);
        return target == null ? key : target;
    }

    public Atom permuteInverse(Atom key) {
        Atom target = this.invs.get(key);
        return target == null ? key : target;
    }

    public Map<Atom, Atom> getPerm() {
        return this.perm;
    }

    public Map<Atom, Atom> getInverse() {
        return this.invs;
    }

    public boolean equals(Object other) {
        if (other instanceof Permutation) {
            Permutation oPerm = (Permutation)other;
            return oPerm.perm.equals(this.perm);
        }
        return false;
    }

    public boolean isEmpty() {
        return this.perm.isEmpty();
    }

    public void clear() {
        this.perm.clear();
        this.invs.clear();
    }

    public Set<Atom[]> getDisagreementSet(Permutation otherPerm, Variable var, FreshnessCtx nabla) {
        HashSet<Atom> composed = new HashSet<Atom>(this.perm.keySet());
        composed.addAll(otherPerm.perm.keySet());
        HashSet<Atom[]> ds = new HashSet<Atom[]>();
        for (Atom atom : composed) {
            Atom a2;
            Atom a1 = this.permute(atom);
            if (a1 == (a2 = otherPerm.permute(atom)) || nabla.contains(atom, var)) continue;
            ds.add(new Atom[]{a1, a2});
        }
        return ds;
    }

    @Override
    public Permutation deepCopy() {
        return new Permutation(this.perm, this.invs);
    }

    public static Permutation compose(Permutation permHeadLeft, Permutation permTailRight) {
        if (permHeadLeft.isEmpty()) {
            return permTailRight.deepCopy();
        }
        if (permTailRight.isEmpty()) {
            return permHeadLeft.deepCopy();
        }
        Permutation permComposed = permTailRight.deepCopy();
        Permutation permTmp = new Permutation(permHeadLeft.perm.size());
        for (Map.Entry<Atom, Atom> mapping : permHeadLeft.perm.entrySet()) {
            Atom a2;
            Atom a1 = permTmp.permute(mapping.getKey());
            if (a1 == (a2 = mapping.getValue())) continue;
            permTmp.addSwappingHead(a1, a2);
            permComposed.addSwappingHead(a1, a2);
        }
        return permComposed;
    }

    public Permutation inverse() {
        return new Permutation(this.invs, this.perm);
    }

    @Override
    public void printString(Writer toPrint) throws IOException {
        this.printString(toPrint, false);
    }

    public void printString(Writer toPrint, boolean useIdString) throws IOException {
        toPrint.append(this.toString(useIdString));
    }

    public CharSequence toString(boolean useIdString) {
        if (this.perm.isEmpty()) {
            return useIdString ? idString : "";
        }
        Permutation permTmp = new Permutation(this.perm.size());
        StringBuilder sb = new StringBuilder(this.perm.size() * 6);
        StringBuilder sb2 = new StringBuilder();
        sb2.appendCodePoint(InputParser.cp_swapStart);
        for (Map.Entry<Atom, Atom> mapping : this.perm.entrySet()) {
            Atom a2;
            Atom a1 = permTmp.permute(mapping.getKey());
            if (a1 == (a2 = mapping.getValue())) continue;
            permTmp.addSwappingHead(a1, a2);
            sb2.setLength(1);
            sb2.append(a1).append(' ').append(a2).appendCodePoint(InputParser.cp_swapEnd);
            sb.insert(0, sb2);
        }
        return sb;
    }
}

