/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.data.term;

import cl.uoh.abaumgart.eqnauac.data.FreshnessCtx;
import cl.uoh.abaumgart.eqnauac.data.term.Atom;
import cl.uoh.abaumgart.eqnauac.data.term.NominalTerm;
import cl.uoh.abaumgart.eqnauac.data.term.Permutation;
import cl.uoh.abaumgart.eqnauac.data.term.Symbol;
import cl.uoh.abaumgart.eqnauac.data.term.Variable;
import java.io.IOException;
import java.io.Writer;

public class Suspension
extends NominalTerm {
    public Permutation perm;
    public Variable vari;

    public Suspension(Variable var) {
        this(var, new Permutation());
    }

    public Suspension(Variable var, Permutation perm) {
        this.perm = perm;
        this.vari = var;
    }

    public boolean equals(Object other) {
        if (other instanceof Suspension) {
            Suspension oSusp = (Suspension)other;
            return oSusp.vari == this.vari && oSusp.perm.equals(this.perm);
        }
        return false;
    }

    @Override
    public void printString(Writer toPrint) throws IOException {
        if (!this.perm.isEmpty()) {
            toPrint.append(this.perm.toString(false));
            toPrint.append('\u00b7');
        }
        toPrint.write(this.vari.toString());
    }

    @Override
    public NominalTerm swap(Atom a1, Atom a2) {
        this.perm.addSwappingHead(a1, a2);
        return this;
    }

    @Override
    public boolean isFresh(Atom atom, FreshnessCtx nabla) {
        return nabla.contains(this.perm.permuteInverse(atom), this.vari);
    }

    @Override
    public Suspension deepCopy() {
        return new Suspension(this.vari, this.perm.deepCopy());
    }

    @Override
    public NominalTerm substitute(Variable fromVar, NominalTerm toTerm) {
        if (this.vari != fromVar) {
            return this;
        }
        return ((NominalTerm)toTerm.deepCopy()).permute(this.perm);
    }

    @Override
    public NominalTerm permute(Permutation perm) {
        if (!perm.isEmpty()) {
            this.perm = Permutation.compose(perm, this.perm);
        }
        return this;
    }

    @Override
    public Symbol getHead() {
        return this.vari;
    }

    @Override
    public int getTypeOrdinal() {
        return 30;
    }
}

