/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.data.term;

import cl.uoh.abaumgart.eqnauac.util.Printable;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;

public final class SymbolSet<T extends Printable> {
    private String fresh1SymbolPrefix;
    private String fresh2SymbolPrefix;
    private String tmpSymbolPrefix;
    private Function<String, T> symbolProvider;
    private Class<? extends Printable> clazz;
    private Map<String, T> usedSymbols;
    private long fresh1SymbolIdx;
    private long fresh2SymbolIdx;
    private long freshTmpSymbolIdx;

    public SymbolSet(String fresh1SymbolPrefix, String fresh2SymbolPrefix, Function<String, T> symbolProvider) {
        this.fresh1SymbolPrefix = fresh1SymbolPrefix;
        this.fresh2SymbolPrefix = fresh2SymbolPrefix;
        this.tmpSymbolPrefix = "~" + fresh2SymbolPrefix;
        this.symbolProvider = symbolProvider;
        this.clazz = ((Printable)((Object)symbolProvider.apply(""))).getClass();
        this.reset();
    }

    public T parseSymbol(String name) {
        return (T)this.usedSymbols.compute(name, (k, v) -> v == null ? (Printable)this.symbolProvider.apply((String)k) : v);
    }

    public T[] fresh1Symbols(int length) {
        Printable[] ret = (Printable[])Array.newInstance(this.clazz, length);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.fresh1Symbol();
        }
        return ret;
    }

    public T[] fresh2Symbols(int length) {
        Printable[] ret = (Printable[])Array.newInstance(this.clazz, length);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.fresh2Symbol();
        }
        return ret;
    }

    public T fresh1Symbol() {
        String name;
        while (this.usedSymbols.containsKey(name = this.fresh1SymbolPrefix + ++this.fresh1SymbolIdx)) {
        }
        return this.parseSymbol(name);
    }

    public T fresh2Symbol() {
        String name;
        while (this.usedSymbols.containsKey(name = this.fresh2SymbolPrefix + ++this.fresh2SymbolIdx)) {
        }
        return this.parseSymbol(name);
    }

    public void reset() {
        this.usedSymbols = new TreeMap<String, T>();
        this.fresh1SymbolIdx = 0L;
        this.fresh2SymbolIdx = 0L;
    }

    public Collection<T> getUsedSymbols() {
        return this.usedSymbols.values();
    }

    public T freshTmpSymbol() {
        if (this.freshTmpSymbolIdx > 999999L) {
            this.tmpSymbolPrefix = "~" + this.tmpSymbolPrefix;
            this.freshTmpSymbolIdx = 0L;
        }
        String freshName = this.tmpSymbolPrefix + String.format("%06d", this.freshTmpSymbolIdx);
        ++this.freshTmpSymbolIdx;
        return (T)((Printable)this.symbolProvider.apply(freshName));
    }

    public static abstract class Symbol
    extends Printable
    implements Comparable<Symbol> {
        private final String name;

        protected Symbol(String name) {
            this.name = name;
        }

        @Override
        public void printString(Writer toPrint) throws IOException {
            toPrint.write(this.name);
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Symbol other) {
            return this.name.compareTo(other.name);
        }
    }
}

