/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.data.term;

import cl.uoh.abaumgart.eqnauac.data.term.Atom;
import cl.uoh.abaumgart.eqnauac.data.term.FunctionSymbol;
import cl.uoh.abaumgart.eqnauac.data.term.SymbolSet;
import cl.uoh.abaumgart.eqnauac.data.term.Variable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;

public interface TermSymbols {
    public static final SymbolSet<FunctionSymbol> fncSymb = new SymbolSet<FunctionSymbol>("?", "?", FunctionSymbol::new);
    public static final SymbolSet<Variable> termVar = new SymbolSet<Variable>("Y", "Z", Variable::new);
    public static final SymbolSet<Atom> atomSymb = new SymbolSet<Atom>("a", "b", Atom::new);
    public static final Set<FunctionSymbol> fncSymbA = new TreeSet<FunctionSymbol>();
    public static final Set<FunctionSymbol> fncSymbC = new TreeSet<FunctionSymbol>();

    public static void addFncSymbsA(String associativeSymbols) {
        fncSymbA.addAll(TermSymbols.parseFncSymbs(associativeSymbols));
    }

    public static void addFncSymbsC(String commutativeSymbols) {
        fncSymbC.addAll(TermSymbols.parseFncSymbs(commutativeSymbols));
    }

    public static List<FunctionSymbol> parseFncSymbs(String symbols) {
        return Arrays.stream(symbols.split("[ ,;:.#(){}\\[\\]]+")).filter(Predicate.not(String::isEmpty)).map(e -> fncSymb.parseSymbol((String)e)).toList();
    }

    public static List<Atom> parseAtoms(String atoms) {
        return Arrays.stream(atoms.split("[ ,;:.#(){}\\[\\]]+")).filter(Predicate.not(String::isEmpty)).map(e -> atomSymb.parseSymbol((String)e)).toList();
    }

    public static String toSet(Set<FunctionSymbol> symbSet) {
        String tmp = symbSet.toString();
        return "{" + tmp.substring(1, tmp.length() - 1) + "}";
    }

    public static void resetAll() {
        fncSymb.reset();
        termVar.reset();
        atomSymb.reset();
        fncSymbA.clear();
        fncSymbC.clear();
    }
}

