/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.util;

import cl.uoh.abaumgart.eqnauac.util.Pool;
import cl.uoh.abaumgart.eqnauac.util.Poolable;
import cl.uoh.abaumgart.eqnauac.util.TinyList;
import java.util.Arrays;

public class CoordList
extends TinyList<int[]>
implements Poolable {
    private int[][] coords = new int[32][];
    private int size = 0;
    private static final Pool<CoordList> coordListPool = Pool.getPool(new CoordList());

    private CoordList() {
    }

    public static CoordList obtainList() {
        return coordListPool.obtain();
    }

    public boolean contains(int x, int y) {
        for (int i = this.size - 1; i >= 0; --i) {
            int[] c = this.coords[i];
            if (c[0] != x || c[1] != y) continue;
            return true;
        }
        return false;
    }

    public void add(int x, int y) {
        int[] c;
        if (this.size == this.coords.length) {
            this.coords = (int[][])Arrays.copyOf(this.coords, this.size + (this.size >> 1));
        }
        if ((c = this.coords[this.size]) == null) {
            c = new int[2];
            this.coords[this.size] = c;
        }
        c[0] = x;
        c[1] = y;
        ++this.size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int[] get(int i) {
        return this.coords[i];
    }

    @Override
    public void removeLast() {
        --this.size;
    }

    public static void fullCleanUp() {
        coordListPool.removePool();
    }

    public void free() {
        coordListPool.free(this);
    }

    @Override
    public Poolable newObject() {
        return new CoordList();
    }

    @Override
    public void cleanUp() {
        this.size = 0;
    }
}

