/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.util;

import cl.uoh.abaumgart.eqnauac.data.Equation;
import cl.uoh.abaumgart.eqnauac.util.DeepCopyable;
import cl.uoh.abaumgart.eqnauac.util.Printable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class EquationSequence<U extends Printable, T extends Equation<U>>
extends Printable
implements DeepCopyable<EquationSequence<U, T>>,
Cloneable,
Iterable<T> {
    protected List<T> equations = new ArrayList<T>();
    public static String EQ_SEPARATOR = ";  ";

    public abstract T addNewEquation(U var1, U var2);

    public int size() {
        return this.equations.size();
    }

    public boolean isEmpty() {
        return this.equations.isEmpty();
    }

    public T get(int idx) {
        return (T)((Equation)this.equations.get(idx));
    }

    public T remove(int idx, boolean allowSwapLast) {
        if (!allowSwapLast) {
            return (T)((Equation)this.equations.remove(idx));
        }
        Equation last = (Equation)this.equations.removeLast();
        return (T)(idx == this.equations.size() ? last : this.equations.set(idx, last));
    }

    public T removeLast() {
        return (T)((Equation)this.equations.removeLast());
    }

    public void clear() {
        this.equations.clear();
    }

    public Stream<T> stream() {
        return this.equations.stream();
    }

    public void add(T element) {
        this.equations.add(element);
    }

    public void addAll(Collection<T> elements) {
        this.equations.addAll(elements);
    }

    @Override
    public void printString(Writer toPrint) throws IOException {
        boolean first = true;
        toPrint.append('{');
        for (Equation elem : this.equations) {
            if (first) {
                first = false;
            } else {
                toPrint.write(EQ_SEPARATOR);
            }
            elem.printString(toPrint);
        }
        toPrint.append('}');
    }

    @Override
    public EquationSequence<U, T> deepCopy() {
        try {
            EquationSequence ret = (EquationSequence)this.clone();
            ret.equations = this.equations.stream().map(DeepCopyable::deepCopy).collect(Collectors.toCollection(ArrayList::new));
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.equations.iterator();
    }
}

