/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.util;

import cl.uoh.abaumgart.eqnauac.util.PerfectHashable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PerfectHashMap<K extends PerfectHashable, V>
extends AbstractMap<K, V> {
    private final K[] keys;
    private final V[] vals;

    public PerfectHashMap(K[] allKeys) {
        for (int i = 0; i < allKeys.length; ++i) {
            allKeys[i].setHashIdx(i);
        }
        this.keys = allKeys;
        Object[] values = new Object[allKeys.length];
        this.vals = values;
    }

    public PerfectHashMap(PerfectHashMap<K, V> toCopy) {
        this.keys = toCopy.keys;
        this.vals = Arrays.copyOf(toCopy.vals, toCopy.vals.length);
    }

    @Override
    public V get(Object key) {
        V v;
        if (key instanceof PerfectHashable) {
            PerfectHashable phKey = (PerfectHashable)key;
            v = this.vals[phKey.getHashIdx()];
        } else {
            v = null;
        }
        return v;
    }

    @Override
    public V put(K key, V value) {
        V oldVal = this.vals[key.getHashIdx()];
        this.vals[key.getHashIdx()] = value;
        return oldVal;
    }

    @Override
    public V remove(Object key) {
        V oldVal = this.get(key);
        if (oldVal != null) {
            this.vals[((PerfectHashable)key).getHashIdx()] = null;
        }
        return oldVal;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return PerfectHashMap.this.keys.length;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                int idx;

                @Override
                public boolean hasNext() {
                    return this.idx < PerfectHashMap.this.keys.length;
                }

                @Override
                public Map.Entry<K, V> next() {
                    return new MyEntry(this.idx++);
                }
            };
        }

        class MyEntry
        implements Map.Entry<K, V> {
            private int currIdx;

            public MyEntry(int idx) {
                this.currIdx = idx;
            }

            @Override
            public K getKey() {
                return PerfectHashMap.this.keys[this.currIdx];
            }

            @Override
            public V getValue() {
                return PerfectHashMap.this.vals[this.currIdx];
            }

            @Override
            public V setValue(V value) {
                Object oldVal = PerfectHashMap.this.vals[this.currIdx];
                PerfectHashMap.this.vals[this.currIdx] = value;
                return oldVal;
            }
        }
    }
}

