/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.util;

import cl.uoh.abaumgart.eqnauac.util.Poolable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Pool<T extends Poolable> {
    private static HashMap<Class<? extends Poolable>, Pool<? extends Poolable>> pools = new HashMap();
    private List<T> freeObjects = new ArrayList<T>();
    private T sample;

    private Pool() {
    }

    public T obtain() {
        int idx = this.freeObjects.size();
        this.sample = idx == 0 ? this.sample.newObject() : (Poolable)this.freeObjects.remove(idx - 1);
        return this.sample;
    }

    public void free(T obj) {
        obj.cleanUp();
        this.freeObjects.add(obj);
    }

    public static <T extends Poolable> Pool<T> getPool(T sample) {
        Pool<Poolable> p = pools.get(sample.getClass());
        if (p == null) {
            p = new Pool<T>();
            p.sample = sample;
            pools.put(sample.getClass(), p);
        }
        return p;
    }

    public void removePool() {
        pools.remove(this.getClass());
    }
}

