/*
 * Decompiled with CFR 0.152.
 */
package cl.uoh.abaumgart.eqnauac.util;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;

public interface VirtualLogging {
    public static final LoggingConfig LOGGING_CONFIG = new LoggingConfig();
    public static final Level LVL_OFF = Level.OFF;
    public static final Level LVL_SIMPLE_AU = Level.SEVERE;
    public static final Level LVL_SIMPLE_EQ = Level.WARNING;
    public static final Level LVL_VERBOSE_AU = Level.CONFIG;
    public static final Level LVL_VERBOSE_EQ = Level.FINE;
    public static final Level LVL_PROGRESS_AU = Level.FINER;
    public static final Level LVL_PROGRESS_EQ = Level.FINEST;
    public static final Level LVL_DEBUG = new Level("DEBUG", 100){};
    public static final Level LVL_ALL = Level.ALL;

    default public void logInfo(String info) {
        VirtualLogging.LOGGING_CONFIG.infoConsumer.accept(info);
    }

    default public void logWarn(String warning) {
        VirtualLogging.LOGGING_CONFIG.warnConsumer.accept(warning);
    }

    default public void logWarn(Level level, Object ... warningToConcat) {
        if (level.intValue() >= VirtualLogging.LOGGING_CONFIG.logLevel.intValue()) {
            this.logWarn(Arrays.stream(warningToConcat).map(String::valueOf).collect(Collectors.joining()));
        }
    }

    default public void logInfo(Level level, Object ... infoToConcat) {
        if (level.intValue() >= VirtualLogging.LOGGING_CONFIG.logLevel.intValue()) {
            this.logInfo(Arrays.stream(infoToConcat).map(String::valueOf).collect(Collectors.joining()));
        }
    }

    default public void logMsg(String msg) {
        VirtualLogging.LOGGING_CONFIG.msgConsumer.accept(msg);
    }

    default public void logMsg(Level level, Object ... msgToConcat) {
        if (level.intValue() >= VirtualLogging.LOGGING_CONFIG.logLevel.intValue()) {
            this.logMsg(Arrays.stream(msgToConcat).map(String::valueOf).collect(Collectors.joining()));
        }
    }

    default public void logErr(Throwable ex) {
        VirtualLogging.LOGGING_CONFIG.errConsumer.accept(ex);
    }

    public static final class LoggingConfig {
        public Consumer<String> infoConsumer = System.out::println;
        public Consumer<String> msgConsumer = System.out::println;
        public Consumer<String> warnConsumer = System.err::println;
        public Consumer<Throwable> errConsumer = ex -> ex.printStackTrace(System.err);
        public Level logLevel = Level.FINE;

        private LoggingConfig() {
        }
    }
}

